/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.util;

import de.galan.commons.logging.Say;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;

public class JmxUtil {
    public static void registerMBean(String packageName, String type, String name, Object mbean) {
        try {
            String pkg = StringUtils.defaultString((String)packageName, (String)mbean.getClass().getPackage().getName());
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = new ObjectName(pkg + ":type=" + type + ",name=" + name);
            if (server.isRegistered(on)) {
                Say.debug((Object)"MBean with type {type} and name {name} for {package} has already been defined, ignoring", type, name, pkg);
            } else {
                server.registerMBean(mbean, on);
            }
        }
        catch (Exception ex) {
            Say.warn((Object)"MBean could not be registered", ex);
        }
    }
}

