/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class BOM {
    private static final byte[] BOM_ARRAY = new byte[]{-17, -69, -65};
    private static final int UTF8_BOM_LENGTH = BOM_ARRAY.length;

    public static String getBOM() {
        return new String(BOM_ARRAY, StandardCharsets.UTF_8);
    }

    public static OutputStream writeBom(OutputStream out) throws IOException {
        if (out != null) {
            out.write(BOM_ARRAY);
        }
        return out;
    }

    public static String clean(String input) {
        byte[] bytes;
        String result = input;
        if (StringUtils.isNotBlank((CharSequence)input) && BOM.isUTF8(bytes = input.getBytes(StandardCharsets.UTF_8))) {
            byte[] barray = new byte[bytes.length - UTF8_BOM_LENGTH];
            System.arraycopy(bytes, UTF8_BOM_LENGTH, barray, 0, barray.length);
            result = new String(barray, StandardCharsets.UTF_8);
        }
        return result;
    }

    public static boolean isUTF8(byte[] bytes) {
        return bytes != null && bytes.length >= UTF8_BOM_LENGTH && bytes[0] == BOM_ARRAY[0] && bytes[1] == BOM_ARRAY[1] && bytes[2] == BOM_ARRAY[2];
    }
}

