/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.time;

import de.galan.commons.time.Durations;
import de.galan.commons.time.Instants;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class Times {
    public static TimeBuilder when(Date date) {
        return Times.when(date.toInstant());
    }

    public static TimeBuilder when(Instant date) {
        return new TimeBuilder(date);
    }

    public static class TimeBuilder {
        private Instant ref;

        TimeBuilder(Instant date) {
            this.ref = date;
        }

        public boolean equalsExactly(Date other) {
            return this.equalsExactly(other.toInstant());
        }

        public boolean equalsExactly(Instant other) {
            return this.equals(other, false);
        }

        public boolean equals(Date other) {
            return this.equals(other.toInstant());
        }

        public boolean equals(Instant other) {
            return this.equals(other, true);
        }

        protected boolean equals(Instant other, boolean ignoreMs) {
            boolean result = false;
            if (this.ref != null) {
                result = ignoreMs ? this.truncate(this.ref) == this.truncate(other) : this.ref.toEpochMilli() == other.toEpochMilli();
            } else if (this.ref == null && other == null) {
                result = true;
            }
            return result;
        }

        protected long truncate(Instant date) {
            return date.toEpochMilli() / 1000L;
        }

        protected long truncate(long time) {
            return time / 1000L;
        }

        public boolean after(Date date) {
            return this.after(date.toInstant());
        }

        public boolean after(Instant date) {
            return this.ref.toEpochMilli() > date.toEpochMilli();
        }

        public boolean before(Date date) {
            return this.before(date.toInstant());
        }

        public boolean before(Instant date) {
            return this.ref.toEpochMilli() < date.toEpochMilli();
        }

        public BetweenTimeBuilder between(Date start) {
            return this.between(start.toInstant());
        }

        public BetweenTimeBuilder between(Instant start) {
            return new BetweenTimeBuilder(this.ref, start);
        }

        public IsTimeBuilder isAtLeast(String time) {
            return this.isAtLeast(Durations.dehumanize(time));
        }

        public IsTimeBuilder isAtLeast(long ms) {
            return new IsTimeBuilder(this.ref, ms, true);
        }

        public IsTimeBuilder isAtMost(String time) {
            return this.isAtMost(Durations.dehumanize(time));
        }

        public IsTimeBuilder isAtMost(long ms) {
            return new IsTimeBuilder(this.ref, ms, false);
        }

        public boolean isWeekday(Instants.WeekdayUnit weekday) {
            return this.isWeekday(weekday, ZoneId.systemDefault());
        }

        public boolean isWeekday(Instants.WeekdayUnit weekday, ZoneId zone) {
            LocalDateTime ldt = LocalDateTime.ofInstant(this.ref, zone);
            return ldt.getDayOfWeek().equals(weekday.getUnit());
        }
    }

    public static class BetweenTimeBuilder {
        private Instant ref;
        private Instant start;

        BetweenTimeBuilder(Instant ref, Instant start) {
            this.ref = ref;
            this.start = start;
        }

        public boolean and(Date end) {
            return this.and(end.toInstant());
        }

        public boolean and(Instant end) {
            long timeEnd;
            long timeRef = this.ref.toEpochMilli();
            long timeStart = this.start.toEpochMilli();
            if (timeStart > (timeEnd = end.toEpochMilli())) {
                long temp = timeStart;
                timeStart = timeEnd;
                timeEnd = temp;
            }
            return timeStart <= timeRef && timeEnd >= timeRef;
        }
    }

    public static class IsTimeBuilder {
        private Instant ref;
        private long ms;
        private boolean atLeast;

        IsTimeBuilder(Instant ref, long ms, boolean atLeast) {
            this.ref = ref;
            this.ms = ms;
            this.atLeast = atLeast;
        }

        public boolean before(Date date) {
            return this.before(date.toInstant());
        }

        public boolean before(Instant date) {
            long timeRef = this.ref.toEpochMilli();
            long timeDate = date.toEpochMilli();
            if (this.atLeast) {
                return timeRef < timeDate - this.ms;
            }
            return timeRef >= timeDate - this.ms && timeRef <= timeDate;
        }

        public boolean after(Date date) {
            return this.after(date.toInstant());
        }

        public boolean after(Instant date) {
            long timeRef = this.ref.toEpochMilli();
            long timeDate = date.toEpochMilli();
            if (this.atLeast) {
                return this.ref.toEpochMilli() > date.toEpochMilli() + this.ms;
            }
            return timeRef <= timeDate + this.ms && timeRef >= timeDate;
        }
    }
}

