/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.time;

import de.galan.commons.logging.Say;
import de.galan.commons.time.ApplicationClock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class Instants {
    public static final String DATE_FORMAT_LOCAL_INPUT = "yyyy-MM-dd HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS]";
    public static final String DATE_FORMAT_LOCAL_NANO_OUTPUT = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final String DATE_FORMAT_LOCAL_MILLI_OUTPUT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMAT_UTC_INPUT = "yyyy-MM-dd'T'HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS]'Z'";
    public static final String DATE_FORMAT_UTC_NANO6_OUTPUT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'";
    public static final String DATE_FORMAT_UTC_NANO9_OUTPUT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'";
    public static final String DATE_FORMAT_UTC_MILLI_OUTPUT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final ZoneId ZONE_LOCAL = ZoneId.systemDefault().normalized();
    public static final ZoneId ZONE_UTC = ZoneId.of("UTC").normalized();
    private static final Map<String, DateTimeFormatter> FORMATTERS = new ConcurrentHashMap<String, DateTimeFormatter>();

    private static DateTimeFormatter getFormater(String pattern, String timezone) {
        String key = pattern + "//" + timezone;
        DateTimeFormatter result = FORMATTERS.get(key);
        if (result == null) {
            result = DateTimeFormatter.ofPattern(pattern);
            if (StringUtils.isNotBlank((CharSequence)timezone)) {
                result = result.withZone(ZoneId.of(timezone));
            }
            FORMATTERS.put(key, result);
        }
        return result;
    }

    public static Instant now() {
        return Instant.now(ApplicationClock.getClock());
    }

    public static Instant tomorrow() {
        return Instants.now().plus(1L, ChronoUnit.DAYS);
    }

    public static Instant yesterday() {
        return Instants.now().minus(1L, ChronoUnit.DAYS);
    }

    public static Date dateNow() {
        return Date.from(Instants.now());
    }

    public static Date dateLocal(String text) {
        Instant instant = Instants.instantLocal(text);
        return instant != null ? Date.from(instant) : null;
    }

    public static Date date(long epochMilli) {
        return new Date(epochMilli);
    }

    public static Date dateUtc(String text) {
        return Date.from(Instants.instantUtc(text));
    }

    public static Instant instantLocal(String text) {
        return Instants.instant(text, ZONE_LOCAL);
    }

    public static Instant instant(String text, ZoneId zone) {
        Instant result = null;
        try {
            LocalDateTime ldt = LocalDateTime.parse(text, Instants.getFormater(DATE_FORMAT_LOCAL_INPUT, null));
            ZonedDateTime zdt = ldt.atZone(zone);
            result = zdt.toInstant();
        }
        catch (DateTimeParseException ex) {
            Say.warn((Object)"Instant not constructable {}", ex, text);
        }
        return result;
    }

    public static Instant instantUtc(String text) {
        Instant result = null;
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(text, Instants.getFormater(DATE_FORMAT_UTC_INPUT, "UTC"));
            result = zdt.toInstant();
        }
        catch (DateTimeParseException ex) {
            Say.warn((Object)"Instant not constructable {}", ex, text);
        }
        return result;
    }

    public static Instant instant(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli);
    }

    public static InstantBuilder from(Instant instant) {
        return new InstantBuilder(instant);
    }

    public static InstantBuilder from(Date date) {
        return new InstantBuilder(date.toInstant());
    }

    public static DatetimeUnit milli() {
        return DatetimeUnit.millis;
    }

    public static DatetimeUnit millis() {
        return DatetimeUnit.millis;
    }

    public static DatetimeUnit second() {
        return DatetimeUnit.seconds;
    }

    public static DatetimeUnit seconds() {
        return DatetimeUnit.seconds;
    }

    public static DatetimeUnit minute() {
        return DatetimeUnit.minutes;
    }

    public static DatetimeUnit minutes() {
        return DatetimeUnit.minutes;
    }

    public static DatetimeUnit hour() {
        return DatetimeUnit.hours;
    }

    public static DatetimeUnit hours() {
        return DatetimeUnit.hours;
    }

    public static DatetimeUnit day() {
        return DatetimeUnit.day;
    }

    public static DatetimeUnit days() {
        return DatetimeUnit.day;
    }

    public static DatetimeUnit week() {
        return DatetimeUnit.week;
    }

    public static DatetimeUnit weeks() {
        return DatetimeUnit.week;
    }

    public static DatetimeUnit month() {
        return DatetimeUnit.month;
    }

    public static DatetimeUnit months() {
        return DatetimeUnit.month;
    }

    public static DatetimeUnit year() {
        return DatetimeUnit.year;
    }

    public static DatetimeUnit years() {
        return DatetimeUnit.year;
    }

    public static WeekdayUnit monday() {
        return WeekdayUnit.monday;
    }

    public static WeekdayUnit tuesday() {
        return WeekdayUnit.tuesday;
    }

    public static WeekdayUnit wednesday() {
        return WeekdayUnit.wednesday;
    }

    public static WeekdayUnit thursday() {
        return WeekdayUnit.thursday;
    }

    public static WeekdayUnit friday() {
        return WeekdayUnit.friday;
    }

    public static WeekdayUnit saturday() {
        return WeekdayUnit.saturday;
    }

    public static WeekdayUnit sunday() {
        return WeekdayUnit.sunday;
    }

    public static class InstantBuilder {
        private Instant current;
        private ZoneId zone = ZONE_UTC;

        public InstantBuilder(Instant instant) {
            this.current = instant;
        }

        public InstantBuilder zone(ZoneId zoneId) {
            this.zone = zoneId == null ? ZONE_UTC : zoneId;
            return this;
        }

        public InstantBuilder with(TemporalAdjuster adjuster) {
            this.current = this.current.with(adjuster);
            return this;
        }

        public InstantBuilder in(int amount, DatetimeUnit unit) {
            if (unit == DatetimeUnit.week || unit == DatetimeUnit.month || unit == DatetimeUnit.year) {
                ZonedDateTime zdt = ZonedDateTime.ofInstant(this.current, this.zone);
                this.current = zdt.plus(amount, unit.getUnit()).toInstant();
            } else {
                this.current = this.current.plus((long)amount, unit.getUnit());
            }
            return this;
        }

        public InstantBuilder before(int amount, DatetimeUnit unit) {
            if (unit == DatetimeUnit.week || unit == DatetimeUnit.month || unit == DatetimeUnit.year) {
                ZonedDateTime zdt = ZonedDateTime.ofInstant(this.current, this.zone);
                this.current = zdt.minus(amount, unit.getUnit()).toInstant();
            } else {
                this.current = this.current.minus(amount, unit.getUnit());
            }
            return this;
        }

        public InstantBuilder next(DatetimeUnit unit) {
            return this.truncate(unit).in(1, unit);
        }

        public InstantBuilder previous(DatetimeUnit unit) {
            return this.truncate(unit).before(1, unit);
        }

        public InstantBuilder truncate(DatetimeUnit unit) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(this.current, this.zone);
            switch (unit) {
                case year: {
                    zdt = zdt.withMonth(1);
                }
                case month: {
                    zdt = zdt.withDayOfMonth(1);
                }
                case day: {
                    zdt = zdt.withHour(0);
                }
                case hours: {
                    zdt = zdt.withMinute(0);
                }
                case minutes: {
                    zdt = zdt.withSecond(0);
                }
                case seconds: {
                    zdt = zdt.withNano(0);
                    break;
                }
                case millis: {
                    long millis = zdt.getLong(ChronoField.MILLI_OF_SECOND);
                    zdt = zdt.withNano((int)(millis * 1000000L));
                }
            }
            this.current = zdt.toInstant();
            return this;
        }

        public InstantBuilder next(WeekdayUnit unit) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(this.current, this.zone);
            this.current = zdt.with(TemporalAdjusters.next(unit.getUnit())).toInstant();
            return this;
        }

        public InstantBuilder previous(WeekdayUnit unit) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(this.current, this.zone);
            this.current = zdt.with(TemporalAdjusters.previous(unit.getUnit())).toInstant();
            return this;
        }

        public InstantBuilder at(int hour, int minute, int second) {
            this.truncate(Instants.day());
            this.current = this.current.plus((long)hour, ChronoUnit.HOURS).plus((long)minute, ChronoUnit.MINUTES).plus((long)second, ChronoUnit.SECONDS);
            return this;
        }

        public InstantBuilder at(String time) {
            String[] split = time.split(":");
            int hour = Integer.valueOf(split[0]);
            int min = Integer.valueOf(split[1]);
            int sec = Integer.valueOf(split[2]);
            return this.at(hour, min, sec);
        }

        public InstantBuilder atMidnight() {
            return this.at(0, 0, 0);
        }

        public InstantBuilder atNoon() {
            return this.at(12, 0, 0);
        }

        public long till(Date date) {
            return date.getTime() - this.toLong();
        }

        public long till(Instant instant) {
            return instant.toEpochMilli() - this.toLong();
        }

        public String toString() {
            return this.toStringLocal();
        }

        public String toStringLocal() {
            return this.toStringLocalMillis();
        }

        public String toStringLocalMillis() {
            return this.toStringLocal(Instants.DATE_FORMAT_LOCAL_MILLI_OUTPUT);
        }

        public String toStringLocalNanos() {
            return this.toStringLocal(Instants.DATE_FORMAT_LOCAL_NANO_OUTPUT);
        }

        public String toStringLocal(String format) {
            return this.toString(ZONE_LOCAL, format);
        }

        public String toStringUtcMillis() {
            return Instants.getFormater(Instants.DATE_FORMAT_UTC_MILLI_OUTPUT, "UTC").format(this.current);
        }

        @Deprecated(since="2.0.1", forRemoval=true)
        public String toStringUtcNano() {
            return Instants.getFormater(Instants.DATE_FORMAT_UTC_NANO6_OUTPUT, "UTC").format(this.current);
        }

        public String toStringUtcNano6() {
            return Instants.getFormater(Instants.DATE_FORMAT_UTC_NANO6_OUTPUT, "UTC").format(this.current);
        }

        public String toStringUtcNano9() {
            return Instants.getFormater(Instants.DATE_FORMAT_UTC_NANO9_OUTPUT, "UTC").format(this.current);
        }

        public String toStringUtc() {
            return this.toStringUtcMillis();
        }

        public String toStringUtc(String format) {
            return this.toString(ZONE_UTC, format);
        }

        protected String toString(ZoneId zoneId, String format) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(this.current, ZONE_UTC);
            return Instants.getFormater(format, zoneId.getId()).format(zdt);
        }

        public long toLong() {
            return this.current.toEpochMilli();
        }

        public Instant toInstant() {
            return this.current;
        }

        public Date toDate() {
            return Date.from(this.current);
        }

        public ZonedDateTime toZdt() {
            return this.toZdt(ZONE_UTC);
        }

        public ZonedDateTime toZdt(ZoneId zoneId) {
            return ZonedDateTime.ofInstant(this.current, zoneId);
        }
    }

    public static enum DatetimeUnit {
        millis(14, ChronoUnit.MILLIS),
        seconds(13, ChronoUnit.SECONDS),
        minutes(12, ChronoUnit.MINUTES),
        hours(11, ChronoUnit.HOURS),
        day(6, ChronoUnit.DAYS),
        week(3, ChronoUnit.WEEKS),
        month(2, ChronoUnit.MONTHS),
        year(1, ChronoUnit.YEARS);

        private final int field;
        private TemporalUnit unit;

        private DatetimeUnit(int field, TemporalUnit unit) {
            this.field = field;
            this.unit = unit;
        }

        public int getField() {
            return this.field;
        }

        public TemporalUnit getUnit() {
            return this.unit;
        }
    }

    public static enum WeekdayUnit {
        monday(2, DayOfWeek.MONDAY),
        tuesday(3, DayOfWeek.TUESDAY),
        wednesday(4, DayOfWeek.WEDNESDAY),
        thursday(5, DayOfWeek.THURSDAY),
        friday(6, DayOfWeek.FRIDAY),
        saturday(7, DayOfWeek.SATURDAY),
        sunday(1, DayOfWeek.SUNDAY);

        private final int field;
        private DayOfWeek unit;

        private WeekdayUnit(int field, DayOfWeek unit) {
            this.field = field;
            this.unit = unit;
        }

        public int getField() {
            return this.field;
        }

        public DayOfWeek getUnit() {
            return this.unit;
        }
    }
}

