/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.time;

import de.galan.commons.collection.SoftReferenceCache;
import de.galan.commons.time.Instants;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Durations {
    private static final Pattern PATTERN_HUMAN_TIME = Pattern.compile("^([0-9]+w)?[ ]*([0-9]+d)?[ ]*([0-9]+h)?[ ]*([0-9]+m[^s]{0})?[ ]*([0-9]+s)?[ ]*([0-9]+ms)?$");
    public static final long MS_MILLISECOND = 1L;
    public static final long MS_SECOND = 1000L;
    public static final long MS_MINUTE = 60000L;
    public static final long MS_HOUR = 3600000L;
    public static final long MS_DAY = 86400000L;
    public static final long MS_WEEK = 604800000L;
    private static SoftReferenceCache<Long> humantimeCache;

    public static String timeLeft(Date date) {
        return Durations.timeLeft(date.toInstant());
    }

    public static String timeLeft(Instant date) {
        return Durations.timeAgo(Instants.now(), date);
    }

    public static String timeAgo(Date date) {
        return Durations.timeAgo(date.toInstant());
    }

    public static String timeAgo(Instant date) {
        return Durations.timeAgo(date, Instants.now());
    }

    protected static String timeAgo(Instant date, Instant reference) {
        String result = "";
        if (date != null && reference != null) {
            long time = reference.toEpochMilli() - date.toEpochMilli();
            result = Durations.humanize(time, " ");
        }
        return result;
    }

    public static String humanize(long time) {
        return Durations.humanize(time, "");
    }

    public static String humanize(Duration duration) {
        return Durations.humanize(duration, "");
    }

    public static String humanize(Duration duration, String separator) {
        return Durations.humanize(duration.toMillis(), separator);
    }

    public static String humanize(long time, String separator) {
        StringBuilder result = new StringBuilder();
        if (time == 0L) {
            result.append("0ms");
        } else {
            long timeLeft = time;
            timeLeft = Durations.appendUnit(timeLeft, separator, 86400000L, "d", result);
            timeLeft = Durations.appendUnit(timeLeft, separator, 3600000L, "h", result);
            timeLeft = Durations.appendUnit(timeLeft, separator, 60000L, "m", result);
            timeLeft = Durations.appendUnit(timeLeft, separator, 1000L, "s", result);
            timeLeft = Durations.appendUnit(timeLeft, separator, 1L, "ms", result);
        }
        return result.toString().trim();
    }

    private static long appendUnit(long time, String separator, long unit, String text, StringBuilder buffer) {
        long result = time;
        if (time >= unit) {
            long hours = time / unit;
            buffer.append(hours);
            buffer.append(text);
            buffer.append(separator);
            result -= unit * hours;
        }
        return result;
    }

    private static SoftReferenceCache<Long> getHumantimeCache() {
        if (humantimeCache == null) {
            humantimeCache = new SoftReferenceCache();
        }
        return humantimeCache;
    }

    public static Long dehumanize(String time) {
        Long result = Durations.getHumantimeCache().get(time);
        if (result == null && StringUtils.isNotBlank((CharSequence)time)) {
            String input = time.trim();
            if (NumberUtils.isDigits((String)input)) {
                result = NumberUtils.toLong((String)input);
            } else {
                Matcher matcher = PATTERN_HUMAN_TIME.matcher(input);
                if (matcher.matches()) {
                    long sum = 0L;
                    sum += Durations.dehumanizeUnit(matcher.group(1), 604800000L);
                    sum += Durations.dehumanizeUnit(matcher.group(2), 86400000L);
                    sum += Durations.dehumanizeUnit(matcher.group(3), 3600000L);
                    sum += Durations.dehumanizeUnit(matcher.group(4), 60000L);
                    sum += Durations.dehumanizeUnit(matcher.group(5), 1000L);
                    result = sum += Durations.dehumanizeUnit(matcher.group(6), 1L);
                }
            }
            Durations.getHumantimeCache().put(time, result);
        }
        return result;
    }

    private static long dehumanizeUnit(String group, long unit) {
        long result = 0L;
        if (StringUtils.isNotBlank((CharSequence)group)) {
            String longString = group.replaceAll("[a-z ]", "");
            result = Long.valueOf(longString) * unit;
        }
        return result;
    }

    public static Duration toDuration(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return Duration.ZERO;
        }
        return Duration.of(Durations.dehumanize(time), ChronoUnit.MILLIS);
    }

    public static String fromDuration(Duration duration) {
        if (duration == null) {
            return null;
        }
        return Durations.humanize(duration.toMillis(), " ");
    }
}

