/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.time;

import de.galan.commons.logging.Logr;
import de.galan.commons.time.ApplicationClock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.Logger;

@Deprecated(forRemoval=true)
public class Dates {
    private static final Logger LOG = Logr.get();
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ThreadLocal<Map<String, SimpleDateFormat>> LOCAL_SDF = ThreadLocal.withInitial(HashMap::new);

    private static SimpleDateFormat getDateFormater(String pattern, String timezone) {
        String key = pattern + "//" + timezone;
        SimpleDateFormat result = LOCAL_SDF.get().get(key);
        if (result == null) {
            result = new SimpleDateFormat(pattern);
            if (StringUtils.isNotBlank((CharSequence)timezone)) {
                result.setTimeZone(TimeZone.getTimeZone(timezone));
            }
            LOCAL_SDF.get().put(key, result);
        }
        return result;
    }

    public static Date now() {
        return new Date(ApplicationClock.getClock().millis());
    }

    public static Date tomorrow() {
        return DateUtils.addDays((Date)Dates.now(), (int)1);
    }

    public static Date yesterday() {
        return DateUtils.addDays((Date)Dates.now(), (int)-1);
    }

    public static DateBuilder from(Date date) {
        return new DateBuilder(date);
    }

    public static Date date(String date) {
        Date result = null;
        try {
            result = Dates.getDateFormater(DATE_FORMAT, null).parse(date);
        }
        catch (ParseException pex) {
            LOG.warn("Date not constructable {}", (Object)pex, (Object)date);
        }
        return result;
    }

    public static Date date(int year, int month, int day, int hour, int minute, int second) {
        return Dates.date(year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second);
    }

    public static Date date(long dateAsLong) {
        return new Date(dateAsLong);
    }

    public static Date dateIso(String date) {
        Date result = null;
        try {
            result = Dates.getDateFormater(DATE_FORMAT_ISO, "UTC").parse(date);
        }
        catch (ParseException pex) {
            LOG.warn("Date not constructable {}", (Object)pex, (Object)date);
        }
        return result;
    }

    public static DatetimeUnit milli() {
        return DatetimeUnit.millis;
    }

    public static DatetimeUnit millis() {
        return DatetimeUnit.millis;
    }

    public static DatetimeUnit second() {
        return DatetimeUnit.seconds;
    }

    public static DatetimeUnit seconds() {
        return DatetimeUnit.seconds;
    }

    public static DatetimeUnit minute() {
        return DatetimeUnit.minutes;
    }

    public static DatetimeUnit minutes() {
        return DatetimeUnit.minutes;
    }

    public static DatetimeUnit hour() {
        return DatetimeUnit.hours;
    }

    public static DatetimeUnit hours() {
        return DatetimeUnit.hours;
    }

    public static DatetimeUnit day() {
        return DatetimeUnit.day;
    }

    public static DatetimeUnit days() {
        return DatetimeUnit.day;
    }

    public static DatetimeUnit week() {
        return DatetimeUnit.week;
    }

    public static DatetimeUnit weeks() {
        return DatetimeUnit.week;
    }

    public static DatetimeUnit month() {
        return DatetimeUnit.month;
    }

    public static DatetimeUnit months() {
        return DatetimeUnit.month;
    }

    public static DatetimeUnit year() {
        return DatetimeUnit.year;
    }

    public static DatetimeUnit years() {
        return DatetimeUnit.year;
    }

    public static WeekdayUnit monday() {
        return WeekdayUnit.monday;
    }

    public static WeekdayUnit tuesday() {
        return WeekdayUnit.tuesday;
    }

    public static WeekdayUnit wednesday() {
        return WeekdayUnit.wednesday;
    }

    public static WeekdayUnit thursday() {
        return WeekdayUnit.thursday;
    }

    public static WeekdayUnit friday() {
        return WeekdayUnit.friday;
    }

    public static WeekdayUnit saturday() {
        return WeekdayUnit.saturday;
    }

    public static WeekdayUnit sunday() {
        return WeekdayUnit.sunday;
    }

    public static class DateBuilder {
        private Calendar cal = new GregorianCalendar(Locale.GERMAN);

        public DateBuilder(Date date) {
            this.cal.setTime(date);
            this.cal.setLenient(true);
        }

        public DateBuilder in(int amount, DatetimeUnit unit) {
            this.cal.add(unit.getField(), amount);
            return this;
        }

        public DateBuilder before(int amount, DatetimeUnit unit) {
            this.cal.add(unit.getField(), -1 * amount);
            return this;
        }

        public DateBuilder next(DatetimeUnit unit) {
            return this.move(unit, 1);
        }

        public DateBuilder previous(DatetimeUnit unit) {
            return this.move(unit, -1);
        }

        public DateBuilder next(WeekdayUnit unit) {
            this.in(1, Dates.day());
            int dow = this.cal.get(7);
            int days = (unit.getField() - dow + 7) % 7;
            return this.in(days, Dates.days());
        }

        public DateBuilder previous(WeekdayUnit unit) {
            int dow = this.cal.get(7);
            int days = 7 - (unit.getField() - dow + 7) % 7;
            return this.before(days, Dates.days());
        }

        protected DateBuilder move(DatetimeUnit unit, int amount) {
            return this.truncate(unit).in(amount, unit);
        }

        public DateBuilder at(int hour, int minute, int second) {
            this.cal.set(11, hour);
            this.cal.set(12, minute);
            this.cal.set(13, second);
            return this;
        }

        public DateBuilder at(String time) {
            String[] split = time.split(":");
            int hour = Integer.valueOf(split[0]);
            int min = Integer.valueOf(split[1]);
            int sec = Integer.valueOf(split[2]);
            return this.at(hour, min, sec);
        }

        public DateBuilder atMidnight() {
            return this.at(0, 0, 0);
        }

        public DateBuilder atNoon() {
            return this.at(12, 0, 0);
        }

        public DateBuilder truncate(DatetimeUnit unit) {
            switch (unit) {
                case year: {
                    this.cal.set(2, 0);
                }
                case month: {
                    this.cal.set(5, 1);
                }
                case day: {
                    this.cal.set(11, 0);
                }
                case hours: {
                    this.cal.set(12, 0);
                }
                case minutes: {
                    this.cal.set(13, 0);
                }
                case millis: {
                    this.cal.set(14, 0);
                }
            }
            return this;
        }

        public long till(Date date) {
            return date.getTime() - this.cal.getTimeInMillis();
        }

        public Date toDate() {
            return this.cal.getTime();
        }

        public String toString() {
            return this.toString(Dates.DATE_FORMAT);
        }

        public String toString(String format) {
            return Dates.getDateFormater(format, null).format(this.cal.getTime());
        }

        public String toIso8601Utc() {
            return Dates.getDateFormater(Dates.DATE_FORMAT_ISO, "UTC").format(this.cal.getTime());
        }

        public long toLong() {
            return this.cal.getTimeInMillis();
        }

        public Instant toInstant() {
            return Instant.ofEpochMilli(this.toLong());
        }
    }

    public static enum DatetimeUnit {
        millis(14),
        seconds(13),
        minutes(12),
        hours(11),
        day(6),
        week(3),
        month(2),
        year(1);

        private final int field;

        private DatetimeUnit(int field) {
            this.field = field;
        }

        public int getField() {
            return this.field;
        }
    }

    public static enum WeekdayUnit {
        monday(2),
        tuesday(3),
        wednesday(4),
        thursday(5),
        friday(6),
        saturday(7),
        sunday(1);

        private final int field;

        private WeekdayUnit(int field) {
            this.field = field;
        }

        public int getField() {
            return this.field;
        }
    }
}

