/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;

public class ApplicationClock {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Clock clock = Clock.systemUTC();

    public static Clock getClock() {
        return clock;
    }

    public static void setClock(Clock clock) {
        ApplicationClock.clock = clock;
    }

    public static void reset() {
        clock = Clock.systemUTC();
    }

    public static void setIso(Instant time) {
        ApplicationClock.setClock(Clock.fixed(time, ZoneId.of("UTC")));
    }

    public static void setUtc(Date time) {
        ApplicationClock.setClock(Clock.fixed(time.toInstant(), ZoneId.of("UTC")));
    }

    public static void setUtc(String time) {
        Instant instant = Instant.parse(time);
        ApplicationClock.setClock(Clock.fixed(instant, ZoneId.of("UTC")));
    }

    public static void setLocal(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Date result = null;
        try {
            result = sdf.parse(time);
        }
        catch (ParseException pex) {
            throw new RuntimeException("Time is not parseable (" + time + ")", pex);
        }
        ApplicationClock.setClock(Clock.fixed(result.toInstant(), ZoneId.systemDefault()));
    }
}

