/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.test.jupiter;

import de.galan.commons.logging.Logr;
import de.galan.commons.time.Sleeper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerSocketProcessor;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.SocketConnection;

public class SimpleWebserverExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOG = Logr.get();
    protected SocketProcessor server;
    private boolean stopped;
    private SocketConnection connection;

    public static SimpleWebserverBuilder builder() {
        return null;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (!this.stopped) {
            this.stopServer();
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.stopServer();
    }

    public synchronized void startServer(Container container) {
        try {
            this.server = new ContainerSocketProcessor(container);
            this.connection = new SocketConnection(this.server);
            InetSocketAddress address = new InetSocketAddress(this.getPort());
            this.connection.connect((SocketAddress)address);
            LOG.info("Server started");
        }
        catch (Exception ex) {
            Assert.fail((String)("Server could not be started: " + ex.getMessage()));
        }
    }

    protected int getPort() {
        return 12345;
    }

    public void startServerDelayed(final Container container, final String delay) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Sleeper.sleep(delay);
                SimpleWebserverExtension simpleWebserverExtension = SimpleWebserverExtension.this;
                synchronized (simpleWebserverExtension) {
                    if (!SimpleWebserverExtension.this.stopped) {
                        SimpleWebserverExtension.this.startServer(container);
                    }
                }
            }
        }.start();
    }

    public synchronized void stopServer() {
        LOG.info("Stopping server");
        try {
            if (this.server != null) {
                this.server.stop();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.stopped = true;
        }
        catch (IOException ex) {
            Assert.fail((String)("Server could not be stopped: " + ex.getMessage()));
        }
    }

    public static class SimpleWebserverBuilder {
        Integer builderPort;
        SimpleWebserverExtension ext;

        public SimpleWebserverBuilder(SimpleWebserverExtension ext) {
            this.ext = ext;
        }

        public SimpleWebserverBuilder port(Integer port) {
            this.builderPort = port;
            return this;
        }

        public void build() {
        }
    }
}

