/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.test.jupiter;

import de.galan.commons.time.ApplicationClock;
import java.time.Clock;
import java.time.Instant;
import java.util.Date;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ApplicationClockExtension
implements BeforeEachCallback,
AfterEachCallback {
    private Clock clock;

    public static ApplicationClockExtensionBuilder builder() {
        return new ApplicationClockExtensionBuilder();
    }

    public ApplicationClockExtension() {
        this(null);
    }

    public ApplicationClockExtension(Clock clock) {
        this.clock = clock == null ? Clock.systemUTC() : clock;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ApplicationClock.setClock(this.clock);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ApplicationClock.reset();
    }

    public static class ApplicationClockExtensionBuilder {
        public ApplicationClockExtensionBuilder clock(Clock clock) {
            ApplicationClock.setClock(clock);
            return this;
        }

        public ApplicationClockExtensionBuilder instant(Instant instant) {
            ApplicationClock.setIso(instant);
            return this;
        }

        public ApplicationClockExtensionBuilder local(String time) {
            ApplicationClock.setLocal(time);
            return this;
        }

        public ApplicationClockExtensionBuilder utc(Date time) {
            ApplicationClock.setUtc(time);
            return this;
        }

        public ApplicationClockExtensionBuilder utc(String time) {
            ApplicationClock.setUtc(time);
            return this;
        }

        public ApplicationClockExtension build() {
            return new ApplicationClockExtension(ApplicationClock.getClock());
        }
    }
}

