/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.test;

import com.google.common.io.Resources;
import de.galan.commons.io.file.FileSupport;
import de.galan.commons.io.streams.IOSupport;
import de.galan.commons.time.Durations;
import de.galan.commons.time.Instants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;

public class Tests {
    public static String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static File getTestDirectory(boolean cleanup) {
        File dir = new File(Tests.getWorkingDirectory(), "target/tests-commons");
        if (cleanup) {
            FileSupport.deleteFileQuiet(dir);
        }
        dir.mkdirs();
        return dir;
    }

    public static File getTestDirectory() {
        return Tests.getTestDirectory(false);
    }

    public static byte[] readFileBinary(Class<?> clazz, String filename) throws IOException {
        return Resources.toByteArray((URL)Resources.getResource(clazz, (String)filename));
    }

    public static String readFile(String filename) throws IOException {
        return Tests.readFile(filename, StandardCharsets.UTF_8);
    }

    public static String readFile(String filename, Charset encoding) throws IOException {
        File file = new File(filename);
        return Tests.readFile(new FileInputStream(file), encoding);
    }

    public static String readFile(Class<?> clazz, String filename) throws IOException {
        return Tests.readFile(clazz, filename, StandardCharsets.UTF_8);
    }

    public static String readFile(Class<?> clazz, String filename, Charset encoding) throws IOException {
        return Tests.readFile(clazz.getResourceAsStream(filename), encoding);
    }

    public static String readFile(InputStream is) throws IOException {
        return Tests.readFile(is, StandardCharsets.UTF_8);
    }

    public static String readFile(InputStream is, Charset encoding) throws IOException {
        return IOSupport.inputstreamToString(is, encoding);
    }

    public static void assertFileEqualsToString(String filename, Class<?> clz, String actual) throws IOException {
        Assertions.assertThat((String)actual).isEqualTo(Tests.readFile(clz, filename));
    }

    public static void assertBetween(Long expectedLow, Long expectedHigh, Long actual) {
        Assertions.assertThat((Long)actual).isBetween(expectedLow, expectedHigh);
    }

    public static void assertListEquals(List<?> expected, List<?> actual) {
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    public static void assertBetween(Date expectedFrom, Date expectedTo, Date actual) {
        Tests.assertBetween(expectedFrom, expectedTo, actual, false);
    }

    public static void assertBetween(Date expectedFrom, Date expectedTo, Date actual, boolean truncateMillis) {
        Assertions.assertThat((Date)Tests.truncate(actual, truncateMillis)).isBetween(Tests.truncate(expectedFrom, truncateMillis), Tests.truncate(expectedTo, truncateMillis), true, true);
    }

    private static Date truncate(Date actual, boolean truncateMillis) {
        return truncateMillis ? Instants.from(actual).truncate(Instants.millis()).toDate() : actual;
    }

    private static Date truncate(Instant actual, boolean truncateMillis) {
        return truncateMillis ? Instants.from(actual).truncate(Instants.millis()).toDate() : Instants.from(actual).toDate();
    }

    public static void assertBetween(Double expectedLower, Double expectedUpper, Double actual) {
        Assertions.assertThat((Double)actual).isBetween(expectedLower, expectedUpper);
    }

    public static void assertDateNear(long msThreshold, Date actual) {
        Tests.assertDateNear(msThreshold, actual, false);
    }

    public static void assertDateNear(long msThreshold, Date actual, boolean truncateMillis) {
        Assertions.assertThat((Date)Tests.truncate(actual, truncateMillis)).isCloseTo(Tests.truncate(Instants.now(), truncateMillis), msThreshold);
    }

    public static void assertDateNear(String timeThreshold, Date actual) {
        Tests.assertDateNear(timeThreshold, actual, false);
    }

    public static void assertDateNear(String timeThreshold, Instant actual) {
        Tests.assertDateNear(timeThreshold, new Date(actual.toEpochMilli()), false);
    }

    public static void assertDateNear(String timeThreshold, Date actual, boolean truncateMillis) {
        Tests.assertDateNear(Durations.dehumanize(timeThreshold), actual, truncateMillis);
    }
}

