/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.mail;

import de.galan.commons.logging.Say;
import de.galan.commons.net.mail.Attachment;
import de.galan.commons.net.mail.AttachmentDataSource;
import de.galan.commons.net.mail.Mail;
import de.galan.commons.net.mail.MailAddress;
import de.galan.commons.net.mail.MailInvalidException;
import de.galan.commons.net.mail.MailSendException;
import de.galan.commons.time.Instants;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MailMessenger {
    private String noreply;
    private boolean smtpAuth;
    private boolean smtpStarttls;
    private String smtpHost;
    private int smtpPort;
    private String smtpUsername;
    private String smtpPassword;
    private String xmailer;

    protected MailMessenger(MailMessengerBuilder builder) {
        this.noreply = builder.builderNoreply;
        this.smtpAuth = builder.builderSmtpAuth;
        this.smtpStarttls = builder.builderSmtpStarttls;
        this.smtpHost = builder.builderSmtpHost;
        this.smtpPort = builder.builderSmtpPort;
        this.smtpUsername = builder.builderSmtpUsername;
        this.smtpPassword = builder.builderSmtpPassword;
        this.xmailer = builder.builderXmailer;
    }

    public static MailMessengerBuilder build() {
        return new MailMessengerBuilder();
    }

    public void send(Mail mail) throws MailInvalidException, MailSendException {
        this.validate(mail);
        this.deliver(mail);
    }

    protected void deliver(Mail mail) throws MailSendException {
        Properties props = new Properties();
        props.put("mail.smtp.auth", Boolean.toString(this.smtpAuth));
        props.put("mail.smtp.starttls.enable", Boolean.toString(this.smtpStarttls));
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.smtp.port", (Object)this.smtpPort);
        try {
            Session mailSession = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    String username = MailMessenger.this.smtpUsername;
                    String password = MailMessenger.this.smtpPassword;
                    return new PasswordAuthentication(username, password);
                }
            });
            MimeMessage mimeMsg = this.constructMimeMessage(mail, mailSession);
            Transport.send((Message)mimeMsg);
        }
        catch (Exception ex) {
            throw new MailSendException(ex);
        }
    }

    private void validate(Mail mail) throws MailInvalidException {
        String message = null;
        if (mail == null) {
            message = "Mail is null";
        } else if (StringUtils.isBlank((CharSequence)mail.getSubject())) {
            message = "No subject";
        } else if (StringUtils.isBlank((CharSequence)mail.getBodyText())) {
            message = "No body";
        } else if (!mail.hasRecipients()) {
            message = "No recipients";
        } else if (mail.getFrom() == null) {
            message = "No sender";
        }
        if (message != null) {
            throw new MailInvalidException(mail, message);
        }
    }

    private MimeMessage constructMimeMessage(Mail mail, Session mailSession) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(mailSession);
        mimeMessage.setSubject(mail.getSubject(), "UTF-8");
        this.setRecipients(mimeMessage, mail.getRecipientsTo(), Message.RecipientType.TO);
        this.setRecipients(mimeMessage, mail.getRecipientsCc(), Message.RecipientType.CC);
        this.setRecipients(mimeMessage, mail.getRecipientsBcc(), Message.RecipientType.BCC);
        InternetAddress from = null;
        from = mail.getFrom() == null || StringUtils.isBlank((CharSequence)mail.getFrom().getAddress()) ? new InternetAddress(this.noreply) : new InternetAddress(mail.getFrom().getCanonical(true));
        mimeMessage.setFrom((Address)from);
        Address[] replyTo = null;
        if (mail.getReplyTo() != null && StringUtils.isNotBlank((CharSequence)mail.getReplyTo().getAddress())) {
            replyTo = new Address[]{new InternetAddress(mail.getReplyTo().getAddress())};
            mimeMessage.setReplyTo(replyTo);
        }
        mimeMessage.setSentDate(Instants.from(Instants.now()).toDate());
        mimeMessage.setHeader("Content-Transfer-Encoding", "quoted-printable");
        mimeMessage.addHeader("Auto-Submitted", "auto-generated");
        mimeMessage.setHeader("X-Mailer", this.xmailer);
        if (mail.hasHeaders()) {
            Iterator iterator = mail.getHeader().keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String name = key = (String)iterator.next();
                Collection values = mail.getHeader().get((Object)name);
                for (String value : values) {
                    try {
                        name = MimeUtility.encodeText((String)name, (String)"US-ASCII", (String)"Q");
                        value = MimeUtility.encodeText((String)value, (String)"US-ASCII", (String)"Q");
                        mimeMessage.addHeader(name, value);
                    }
                    catch (UnsupportedEncodingException e) {
                        Say.error((Object)"Could not add header, name: {name}, value: {value}", name, value);
                    }
                }
            }
        }
        if (mail.getBodyHtml() != null || mail.hasAttachments()) {
            MimeMultipart content = new MimeMultipart("mixed");
            MimeBodyPart text = new MimeBodyPart();
            text.setText(mail.getBodyText());
            text.setHeader("MIME-Version", "1.0");
            text.setHeader("Content-Type", "text/plain");
            if (mail.getBodyHtml() != null) {
                MimeBodyPart html = new MimeBodyPart();
                html.setContent((Object)mail.getBodyHtml(), "text/html");
                html.setHeader("MIME-Version", "1.0");
                html.setHeader("Content-Type", "text/html");
                MimeMultipart textMultiPart = new MimeMultipart("alternative");
                textMultiPart.addBodyPart((BodyPart)text);
                textMultiPart.addBodyPart((BodyPart)html);
                MimeBodyPart textBodyPart = new MimeBodyPart();
                textBodyPart.setContent((Multipart)textMultiPart);
                content.addBodyPart((BodyPart)textBodyPart);
            } else {
                content.addBodyPart((BodyPart)text);
            }
            if (mail.hasAttachments()) {
                for (Attachment attachment : mail.getAttachments()) {
                    if (!ArrayUtils.isNotEmpty((byte[])attachment.getData())) continue;
                    MimeBodyPart attachmentPart = new MimeBodyPart();
                    AttachmentDataSource datasource = new AttachmentDataSource(attachment);
                    attachmentPart.setDataHandler(new DataHandler((DataSource)datasource));
                    attachmentPart.setFileName(attachment.getFilename());
                    attachmentPart.setDisposition("attachment");
                    content.addBodyPart((BodyPart)attachmentPart);
                }
            }
            mimeMessage.setContent((Multipart)content);
            mimeMessage.setHeader("MIME-Version", "1.0");
            mimeMessage.setHeader("Content-Type", content.getContentType());
        } else {
            mimeMessage.setContent((Object)mail.getBodyText(), "text/plain; charset=\"UTF-8\"");
        }
        return mimeMessage;
    }

    private void setRecipients(MimeMessage mimeMessage, List<MailAddress> recipients, Message.RecipientType type) throws AddressException, MessagingException {
        for (MailAddress address : recipients) {
            mimeMessage.addRecipient(type, (Address)new InternetAddress(address.getAddress()));
        }
    }

    public static class MailMessengerBuilder {
        private String builderNoreply;
        private boolean builderSmtpAuth = true;
        private boolean builderSmtpStarttls = false;
        private String builderSmtpHost;
        private int builderSmtpPort;
        private String builderSmtpUsername;
        private String builderSmtpPassword;
        private String builderXmailer = "";

        public MailMessengerBuilder noreply(String noreply) {
            this.builderNoreply = noreply;
            return this;
        }

        public MailMessengerBuilder smtpAuth(boolean smtpAuth) {
            this.builderSmtpAuth = smtpAuth;
            return this;
        }

        public MailMessengerBuilder smtpStarttls(boolean smtpStarttls) {
            this.builderSmtpStarttls = smtpStarttls;
            return this;
        }

        public MailMessengerBuilder smtpHost(String smtpHost) {
            this.builderSmtpHost = smtpHost;
            return this;
        }

        public MailMessengerBuilder smtpPort(int smtpPort) {
            this.builderSmtpPort = smtpPort;
            return this;
        }

        public MailMessengerBuilder smtpUsername(String smtpUsername) {
            this.builderSmtpUsername = smtpUsername;
            return this;
        }

        public MailMessengerBuilder smtpPassword(String smtpPassword) {
            this.builderSmtpPassword = smtpPassword;
            return this;
        }

        public MailMessengerBuilder xmailer(String xmailer) {
            this.builderXmailer = xmailer;
            return this;
        }

        public MailMessenger create() {
            return new MailMessenger(this);
        }
    }
}

