/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.mail;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class MailAddress {
    @NotNull
    @JsonProperty(value="address")
    private String address;
    @JsonProperty(value="name")
    private String name;

    public static MailAddress of(String address) throws AddressException {
        InternetAddress addr = new InternetAddress(address);
        return new MailAddress(addr.getAddress(), addr.getPersonal());
    }

    public MailAddress(String address) {
        this(address, null);
    }

    @JsonCreator
    public MailAddress(@JsonProperty(value="address") String address, @JsonProperty(value="name") String name) {
        this.address = StringUtils.trimToNull((String)address);
        this.name = StringUtils.trimToNull((String)name);
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCanonical(boolean includeName) {
        Object result = this.getAddress();
        if (includeName && StringUtils.isNotBlank((CharSequence)this.getName())) {
            result = this.getName() + " <" + (String)result + ">";
        }
        return result;
    }

    public String toString() {
        return this.getCanonical(true);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MailAddress) {
            MailAddress other = (MailAddress)obj;
            return new EqualsBuilder().append((Object)this.address, (Object)other.address).append((Object)this.name, (Object)other.name).isEquals();
        }
        return false;
    }
}

