/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.mail;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.galan.commons.net.mail.Attachment;
import de.galan.commons.net.mail.MailAddress;
import de.galan.commons.net.mail.MailPriority;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

public class Mail {
    public static final int PRIORITY_LOW = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final int PRIORITY_HIGH = 3;
    @NotNull
    private String subject;
    @NotNull
    private String bodyText;
    private String bodyHtml;
    @Valid
    @NotNull
    private MailAddress from;
    private MailAddress replyTo;
    private List<MailAddress> recipientsTo = new ArrayList<MailAddress>();
    private List<MailAddress> recipientsCc = new ArrayList<MailAddress>();
    private List<MailAddress> recipientsBcc = new ArrayList<MailAddress>();
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private MailPriority priority = MailPriority.NORMAL;
    private Multimap<String, String> header = HashMultimap.create();

    public Mail() {
    }

    public Mail(String sender, String subject, String ... recipientsTo) {
        this(new MailAddress(sender), subject, recipientsTo);
    }

    public Mail(MailAddress sender, String subject, String ... recipientsTo) {
        this.setFrom(sender);
        this.setSubject(subject);
        for (String recipient : recipientsTo) {
            this.addRecipientTo(new MailAddress(recipient));
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Mail subject(String mailSubject) {
        this.setSubject(mailSubject);
        return this;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void setBodyText(String bodyText) {
        this.bodyText = bodyText;
    }

    public Mail bodyText(String mailBodyText) {
        this.setBodyText(mailBodyText);
        return this;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public void setBodyHtml(String bodyHtml) {
        this.bodyHtml = bodyHtml;
    }

    public Mail bodyHtml(String mailBodyHtml) {
        this.setBodyHtml(mailBodyHtml);
        return this;
    }

    public MailAddress getFrom() {
        return this.from;
    }

    public void setFrom(MailAddress from) {
        this.from = from;
    }

    public Mail from(MailAddress mailFrom) {
        this.setFrom(mailFrom);
        return this;
    }

    public Mail sender(String mailFrom) {
        this.setFrom(new MailAddress(mailFrom));
        return this;
    }

    public MailAddress getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(MailAddress replyTo) {
        this.replyTo = replyTo;
    }

    public Mail replyTo(MailAddress mailReplyTo) {
        this.setReplyTo(mailReplyTo);
        return this;
    }

    public Mail replyTo(String mailReplyTo) {
        this.setReplyTo(new MailAddress(mailReplyTo));
        return this;
    }

    public MailPriority getPriority() {
        return this.priority;
    }

    public void setPriority(MailPriority priority) {
        this.priority = priority;
    }

    public Mail priority(MailPriority MailPriority2) {
        this.setPriority(MailPriority2);
        return this;
    }

    public List<MailAddress> getRecipientsTo() {
        return this.recipientsTo;
    }

    public List<MailAddress> getRecipientsCc() {
        return this.recipientsCc;
    }

    public List<MailAddress> getRecipientsBcc() {
        return this.recipientsBcc;
    }

    public void addRecipientTo(MailAddress address) {
        this.recipientsTo.add(address);
    }

    public void addRecipientCc(MailAddress address) {
        this.recipientsCc.add(address);
    }

    public void addRecipientBcc(MailAddress address) {
        this.recipientsBcc.add(address);
    }

    public Mail to(MailAddress ... mailAddress) {
        if (mailAddress != null) {
            for (MailAddress address : mailAddress) {
                this.addRecipientTo(address);
            }
        }
        return this;
    }

    public Mail to(String ... mailAddress) {
        if (mailAddress != null) {
            for (String address : mailAddress) {
                this.addRecipientTo(new MailAddress(address));
            }
        }
        return this;
    }

    public Mail cc(MailAddress ... mailAddress) {
        if (mailAddress != null) {
            for (MailAddress address : mailAddress) {
                this.addRecipientCc(address);
            }
        }
        return this;
    }

    public Mail cc(String ... mailAddress) {
        if (mailAddress != null) {
            for (String address : mailAddress) {
                this.addRecipientCc(new MailAddress(address));
            }
        }
        return this;
    }

    public Mail bcc(MailAddress ... mailAddress) {
        if (mailAddress != null) {
            for (MailAddress address : mailAddress) {
                this.addRecipientBcc(address);
            }
        }
        return this;
    }

    public Mail bcc(String ... mailAddress) {
        if (mailAddress != null) {
            for (String address : mailAddress) {
                this.addRecipientBcc(new MailAddress(address));
            }
        }
        return this;
    }

    public Multimap<String, String> getHeader() {
        return this.header;
    }

    public void addHeader(String name, String value) {
        this.header.put((Object)name, (Object)value);
    }

    public Mail header(String name, String value) {
        this.addHeader(name, value);
        return this;
    }

    public boolean hasHeaders() {
        return !this.header.isEmpty();
    }

    @JsonIgnore
    public int getNumberRecipients() {
        return this.getRecipientsTo().size() + this.getRecipientsCc().size() + this.getRecipientsBcc().size();
    }

    @AssertTrue
    public boolean hasRecipients() {
        return this.getNumberRecipients() > 0;
    }

    public void addAttachment(Attachment attachment) {
        this.getAttachments().add(attachment);
    }

    public void addAttachments(List<Attachment> listOfAttachments) {
        this.getAttachments().addAll(listOfAttachments);
    }

    public Mail attachment(Attachment mailAttachment) {
        this.addAttachment(mailAttachment);
        return this;
    }

    public void removeAttachment(Attachment attachment) {
        this.getAttachments().remove(attachment);
    }

    public void removeAllAttachments() {
        this.getAttachments().clear();
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public boolean hasAttachments() {
        return !this.getAttachments().isEmpty();
    }

    public String toString() {
        return this.getFrom() + ": " + this.getSubject();
    }
}

