/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.mail;

import de.galan.commons.net.mail.Attachment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class AttachmentDataSource
implements DataSource {
    private Attachment attachment;

    public AttachmentDataSource(Attachment attachment) {
        this.attachment = attachment;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public String getContentType() {
        return this.getAttachment().getMimeType();
    }

    public InputStream getInputStream() throws IOException {
        if (this.attachment.getData() == null || this.attachment.getData().length == 0) {
            throw new IOException("No attachmentdata available");
        }
        return new ByteArrayInputStream(this.attachment.getData());
    }

    public String getName() {
        return this.getAttachment().getFilename();
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

