/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.mail;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.galan.commons.net.MimeType;
import java.io.IOException;
import java.io.InputStream;

public class Attachment {
    private String filename;
    private byte[] data;
    private String mimeType;

    public Attachment(String filename, byte[] data) {
        this(filename, data, MimeType.APPLICATION_OCTETSTREAM);
    }

    public Attachment(String filename, byte[] data, MimeType mimeType) {
        this(filename, data, mimeType.getMimeType());
    }

    @JsonCreator
    public Attachment(@JsonProperty(value="filename") String filename, @JsonProperty(value="data") byte[] data, @JsonProperty(value="mimetype") String mimeType) {
        this.setFilename(filename);
        this.setData(data);
        this.setMimeType(mimeType);
    }

    public Attachment(String filename, InputStream stream) throws IOException {
        this(filename, stream, MimeType.APPLICATION_OCTETSTREAM);
    }

    public Attachment(String filename, InputStream stream, MimeType mimeType) throws IOException {
        this(filename, stream, mimeType.getMimeType());
    }

    public Attachment(String filename, InputStream stream, String mimeType) throws IOException {
        this.setFilename(filename);
        this.setData(stream);
        this.setMimeType(mimeType);
    }

    public byte[] getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(byte[] attachmentData) {
        this.data = attachmentData;
    }

    @JsonIgnore
    public void setData(InputStream stream) throws IOException {
        this.data = stream.readAllBytes();
    }

    public String getMimeType() {
        return this.mimeType == null ? MimeType.APPLICATION_OCTETSTREAM.getMimeType() : this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

