/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.flux;

import de.galan.commons.net.UrlUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UrlConstruction {
    public static String appendParameters(String resource, Map<String, List<String>> parameters) {
        StringBuilder builder = new StringBuilder(resource);
        if (parameters != null && !parameters.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                for (String value : entry.getValue()) {
                    if (entry.getValue() == null) continue;
                    if (first) {
                        builder.append(StringUtils.contains((CharSequence)resource, (CharSequence)"?") ? "&" : "?");
                        first = false;
                    } else {
                        builder.append("&");
                    }
                    builder.append(entry.getKey());
                    if (value == null) continue;
                    builder.append("=");
                    builder.append(UrlUtil.encode(value.toString(), StandardCharsets.UTF_8));
                }
            }
        }
        return builder.toString();
    }

    public static String constructResource(String protocol, String host, Integer port, String path) {
        StringBuilder builder = new StringBuilder();
        builder.append((String)StringUtils.defaultIfBlank((CharSequence)protocol, (CharSequence)"http"));
        builder.append("://");
        builder.append(host);
        if (port != null && port > 0) {
            builder.append(":");
            builder.append(port);
        }
        builder.append((String)(StringUtils.startsWith((CharSequence)path, (CharSequence)"/") ? path : "/" + path));
        return builder.toString();
    }
}

