/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.flux;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import de.galan.commons.io.streams.IOSupport;
import de.galan.commons.logging.Logr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class Response
implements AutoCloseable {
    private static final Logger LOG = Logr.get();
    private static final Map<String, String> EMPTY_HEADERS = ImmutableMap.of();
    private final InputStream dataStream;
    private final int statusCode;
    private final String contentEncoding;
    private final String contentType;
    private final HttpURLConnection connection;
    private final Map<String, String> headerFields;

    public Response(HttpURLConnection connection, InputStream dataStream, int statusCode, String contentEncoding, String contentType, Map<String, String> headerFields) {
        this.connection = connection;
        this.dataStream = dataStream;
        this.statusCode = statusCode;
        this.contentEncoding = contentEncoding;
        this.contentType = contentType;
        this.headerFields = headerFields != null ? headerFields : EMPTY_HEADERS;
    }

    public InputStream getStream() {
        return this.dataStream;
    }

    public byte[] getStreamAsBytearray() throws IOException {
        byte[] result = null;
        try {
            result = this.getStream().readAllBytes();
        }
        catch (NullPointerException npex) {
            throw new IOException("Timeout has been forced by CommonHttpClient", npex);
        }
        return result;
    }

    public String getStreamAsString() throws IOException {
        return this.getStreamAsString("UTF-8");
    }

    public String getStreamAsString(String encoding) throws IOException {
        return this.getStreamAsString(Charset.forName(encoding));
    }

    public String getStreamAsString(Charset charset) throws IOException {
        String result = null;
        try {
            result = IOSupport.inputstreamToString(this.getStream(), charset);
        }
        catch (NullPointerException npex) {
            throw new IOException("Timeout has been forced by CommonHttpClient", npex);
        }
        return result;
    }

    public void storeStream(File file) throws FileNotFoundException, IOException {
        this.storeStream(file, false);
    }

    public void storeStream(File file, boolean gunzip) throws FileNotFoundException, IOException {
        InputStream is = this.getStream();
        if (gunzip) {
            is = new GZIPInputStream(is);
        }
        try (InputStream stream = is;){
            ByteSink sink = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]);
            sink.writeFrom(is);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isFailed() {
        return !this.isSucceded();
    }

    public boolean isInformational() {
        return this.getStatusCode() >= 100 && this.getStatusCode() <= 199;
    }

    public boolean isSucceded() {
        return this.getStatusCode() >= 200 && this.getStatusCode() <= 299;
    }

    public boolean isRedirection() {
        return this.getStatusCode() >= 300 && this.getStatusCode() <= 399;
    }

    public boolean isClientError() {
        return this.getStatusCode() >= 400 && this.getStatusCode() <= 499;
    }

    public boolean isServerError() {
        return this.getStatusCode() >= 500 && this.getStatusCode() <= 599;
    }

    public String getHeaderField(String name) {
        return StringUtils.isBlank((CharSequence)name) ? null : this.getHeaderFields().get(name);
    }

    public Map<String, String> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public void close() {
        if (this.getStream() != null) {
            try {
                this.getStream().close();
            }
            catch (IOException ex) {
                LOG.info("stream could not be closed");
            }
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }
}

