/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.flux;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import de.galan.commons.net.flux.HttpClient;
import de.galan.commons.net.flux.HttpClientException;
import de.galan.commons.net.flux.HttpOptions;
import de.galan.commons.net.flux.Method;
import de.galan.commons.net.flux.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MockCommonHttpClient
implements HttpClient {
    private Iterator<MockResponse> responses;
    private List<Request> requests = new ArrayList<Request>();

    public MockCommonHttpClient() {
    }

    public MockCommonHttpClient(MockResponse response) {
        this.setResponse(response);
    }

    public void setResponse(MockResponse response) {
        this.setResponses(true, response);
    }

    public MockCommonHttpClient response(MockResponse response) {
        this.setResponse(response);
        return this;
    }

    public void setResponses(boolean repeat, MockResponse ... response) {
        this.responses = repeat ? Iterators.cycle(this.createRewindableResponses(response)) : Iterators.forArray((Object[])response);
    }

    private Iterable<MockResponse> createRewindableResponses(MockResponse ... response) {
        return Lists.newArrayList((Object[])response).stream().map(MockResponse::convertToReplayableStream).collect(Collectors.toList());
    }

    public MockCommonHttpClient responses(boolean repeat, MockResponse ... response) {
        this.setResponses(repeat, response);
        return this;
    }

    public List<Request> getRequests() {
        return this.requests;
    }

    public void reset() {
        this.requests.clear();
    }

    protected Response getNextResponse() {
        if (this.responses == null || !this.responses.hasNext()) {
            return null;
        }
        return this.responses.next();
    }

    @Override
    public Response request(String resource, Method method, Map<String, String> extraHeader, Map<String, List<String>> parameters, byte[] body, HttpOptions options) throws HttpClientException {
        this.requests.add(new Request(method, extraHeader, body, resource));
        return this.getNextResponse();
    }

    public static class MockResponse
    extends Response {
        private InputStream mockStream;

        public MockResponse(String body, int statusCode) {
            this(body, statusCode, "text/html;charset=UTF-8");
        }

        public MockResponse(byte[] body, int statusCode, String contentType) {
            this(null, new ByteArrayInputStream(body), statusCode, null, contentType, null);
        }

        public MockResponse(String body, int statusCode, String contentType) {
            this(null, new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)), statusCode, StandardCharsets.UTF_8.toString(), contentType, null);
        }

        public MockResponse(HttpURLConnection connection, InputStream dataStream, int statusCode, String contentEncoding, String contentType, Map<String, String> headerFields) {
            super(connection, null, statusCode, contentEncoding, contentType, headerFields);
            this.mockStream = dataStream;
        }

        @Override
        public InputStream getStream() {
            return this.mockStream;
        }

        MockResponse convertToReplayableStream() {
            this.mockStream = new ReplayableInputStream(this.getStream());
            return this;
        }
    }

    public static class Request {
        public Method method;
        public Map<String, String> extraHeader;
        public byte[] body;
        public String resource;

        public Request(Method method, Map<String, String> extraHeader, byte[] body, String resource) {
            this.method = method;
            this.extraHeader = extraHeader;
            this.body = body;
            this.resource = resource;
        }

        public String getBody() {
            return new String(this.body, StandardCharsets.UTF_8);
        }
    }

    static class ReplayableInputStream
    extends InputStream {
        private InputStream current;
        private ByteArrayOutputStream output;

        public ReplayableInputStream(InputStream input) {
            try {
                this.output = new ByteArrayOutputStream();
                this.output.writeBytes(input.readAllBytes());
                this.reset();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read inputstream", ex);
            }
        }

        @Override
        public void close() throws IOException {
            this.reset();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.current = new ByteArrayInputStream(this.output.toByteArray());
        }

        @Override
        public int read() throws IOException {
            return this.current.read();
        }
    }
}

