/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.flux;

import de.galan.commons.net.CommonProxy;
import de.galan.commons.time.Durations;

public class HttpOptions {
    private static final long DEFAULT_TIMEOUT = Durations.dehumanize("5s");
    private Long timeoutConnection;
    private Long timeoutRead;
    private String authorizationUsername;
    private String authorizationPassword;
    private CommonProxy proxy;
    private Long retriesCount;
    private Long timeBetweenRetries;
    private Boolean followRedirects = true;
    private Boolean timeoutThread = false;

    public Long getTimeoutConnection() {
        return this.timeoutConnection == null ? DEFAULT_TIMEOUT : this.timeoutConnection;
    }

    public void setTimeoutConnection(Long timeoutConnection) {
        this.timeoutConnection = timeoutConnection;
    }

    public Long getTimeoutRead() {
        return this.timeoutRead == null ? DEFAULT_TIMEOUT : this.timeoutRead;
    }

    public void setTimeoutRead(Long timeoutRead) {
        this.timeoutRead = timeoutRead;
    }

    public CommonProxy getProxy() {
        return this.proxy;
    }

    public void enableProxy(CommonProxy commonProxy) {
        this.proxy = commonProxy;
    }

    public boolean isProxyEnabled() {
        return this.proxy != null;
    }

    public long getRetriesCount() {
        return this.retriesCount == null ? 0L : this.retriesCount;
    }

    public Long getTimeBetweenRetries() {
        return this.timeBetweenRetries;
    }

    public void enableRetries(Long retries, Long timeBetween) {
        if (retries != null) {
            this.retriesCount = retries;
            this.timeBetweenRetries = timeBetween;
        }
    }

    public void enableRetries(Long retries, String timeBetween) {
        this.enableRetries(retries, Durations.dehumanize(timeBetween));
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void enableFollowRedirects(Boolean follow) {
        this.followRedirects = follow;
    }

    public Boolean getTimeoutThread() {
        return this.timeoutThread;
    }

    public void enableTimeoutThread(Boolean thread) {
        this.timeoutThread = thread;
    }

    public void enableAuthorization(String username, String password) {
        this.authorizationUsername = username;
        this.authorizationPassword = password;
    }

    public String getAuthorizationUsername() {
        return this.authorizationUsername;
    }

    public String getAuthorizationPassword() {
        return this.authorizationPassword;
    }
}

