/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.flux;

import de.galan.commons.net.flux.CommonHttpClient;
import de.galan.commons.net.flux.FluentHttpClient;
import de.galan.commons.net.flux.HttpClient;
import de.galan.commons.time.Durations;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class Flux {
    private static Long defaultTimeout;
    private static Long defaultTimeoutConnection;
    private static Long defaultTimeoutRead;
    private static Map<String, String> defaultHeader;
    private static Supplier<HttpClient> clientFactory;

    public static void setDefaultTimeout(long timeout) {
        defaultTimeout = timeout;
    }

    public static void setDefaultTimeout(String timeout) {
        defaultTimeout = Durations.dehumanize(timeout);
    }

    public static void setDefaultTimeoutConnection(long timeoutConnection) {
        defaultTimeoutConnection = timeoutConnection;
    }

    public static void setDefaultTimeoutConnection(String timeoutConnection) {
        defaultTimeoutConnection = Durations.dehumanize(timeoutConnection);
    }

    public static void setDefaultTimeoutRead(long timeoutRead) {
        defaultTimeoutRead = timeoutRead;
    }

    public static void setDefaultTimeoutRead(String timeoutRead) {
        defaultTimeoutRead = Durations.dehumanize(timeoutRead);
    }

    public static void clearTimeouts() {
        defaultTimeout = null;
        defaultTimeoutConnection = null;
        defaultTimeoutRead = null;
    }

    public static void addDefaultHeader(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            if (defaultHeader == null) {
                defaultHeader = new HashMap<String, String>();
            }
            defaultHeader.put(key, value);
        }
    }

    public static void clearDefaultHeader() {
        defaultHeader = null;
    }

    public static FluentHttpClient.HttpBuilder request(String resource) {
        return Flux.defaults(Flux.createClient().request(resource));
    }

    public static FluentHttpClient.HttpBuilder request(URL resource) {
        return Flux.defaults(Flux.createClient().request(resource));
    }

    public static FluentHttpClient.HttpBuilder request(String protocol, String host, Integer port, String path) {
        return Flux.defaults(Flux.createClient().request(protocol, host, port, path));
    }

    protected static FluentHttpClient createClient() {
        return new FluentHttpClient(clientFactory.get());
    }

    private static FluentHttpClient.HttpBuilder defaults(FluentHttpClient.HttpBuilder builder) {
        if (defaultTimeout != null) {
            builder.timeout(defaultTimeout);
        }
        if (defaultTimeoutConnection != null) {
            builder.timeoutConnection(defaultTimeoutConnection);
        }
        if (defaultTimeoutRead != null) {
            builder.timeoutRead(defaultTimeoutRead);
        }
        if (defaultHeader != null) {
            builder.headers(defaultHeader);
        }
        return builder;
    }

    public static void setHttpClientFactory(Supplier<HttpClient> clientFactory) {
        Flux.clientFactory = clientFactory;
    }

    public static void resetHttpClientFactory() {
        Flux.setHttpClientFactory(Flux.createDefaultHttpClientSupplier());
    }

    protected static Supplier<HttpClient> createDefaultHttpClientSupplier() {
        return CommonHttpClient::new;
    }

    static {
        clientFactory = Flux.createDefaultHttpClientSupplier();
    }
}

