/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.flux;

import de.galan.commons.net.CommonProxy;
import de.galan.commons.net.flux.CommonHttpClient;
import de.galan.commons.net.flux.HttpClient;
import de.galan.commons.net.flux.HttpClientException;
import de.galan.commons.net.flux.HttpOptions;
import de.galan.commons.net.flux.Method;
import de.galan.commons.net.flux.Response;
import de.galan.commons.net.flux.UrlConstruction;
import de.galan.commons.time.Durations;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FluentHttpClient {
    private HttpClient client;

    public FluentHttpClient() {
    }

    public FluentHttpClient(HttpClient client) {
        this.setClient(client);
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    HttpClient getClient(boolean create) {
        if (this.client == null && create) {
            this.client = new CommonHttpClient();
        }
        return this.client;
    }

    public HttpBuilder request(String protocol, String host, Integer port, String path) {
        String resource = UrlConstruction.constructResource(protocol, host, port, path);
        return this.request(resource);
    }

    public HttpBuilder request(String resource) {
        return new HttpBuilder(this.getClient(true), resource);
    }

    public HttpBuilder request(URL resource) {
        return new HttpBuilder(this.getClient(true), resource.toString());
    }

    public static class HttpBuilder {
        String builderResource;
        byte[] builderBody;
        Long builderTimeout;
        Long builderTimeoutConnection;
        Long builderTimeoutRead;
        CommonProxy builderProxy;
        String builderUsername;
        String builderPassword;
        boolean builderFollowRedirects = true;
        Long builderRetries;
        String builderRetriesTimebetween;
        boolean builderTimeoutThread = false;
        Map<String, String> builderHeader;
        Map<String, List<String>> builderParameter;
        HttpClient builderClient;

        protected HttpBuilder(HttpClient client, String resource) {
            this.builderClient = client;
            this.builderResource = resource;
        }

        public HttpBuilder proxy(String proxy) {
            if (StringUtils.isNotBlank((CharSequence)proxy)) {
                this.builderProxy = CommonProxy.parse(proxy);
            }
            return this;
        }

        public HttpBuilder proxy(CommonProxy proxy) {
            if (proxy != null) {
                this.builderProxy = proxy;
            }
            return this;
        }

        public HttpBuilder proxy(String ip, int port) {
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                this.builderProxy = new CommonProxy(ip, port);
            }
            return this;
        }

        public HttpBuilder proxyAuthentication(String username, String password) {
            this.builderProxy = new CommonProxy(this.builderProxy.getIp(), this.builderProxy.getPort(), username, password);
            return this;
        }

        public HttpBuilder authentication(String username, String password) {
            this.builderUsername = username;
            this.builderPassword = password;
            return this;
        }

        public HttpBuilder timeout(String timeout) {
            return this.timeout(Durations.dehumanize(timeout));
        }

        public HttpBuilder timeout(Integer timeout) {
            return this.timeout(timeout == null ? null : Long.valueOf(timeout.longValue()));
        }

        public HttpBuilder timeout(Long timeout) {
            this.builderTimeout = timeout;
            return this;
        }

        public HttpBuilder timeoutConnection(String timeoutConnection) {
            return this.timeoutConnection(Durations.dehumanize(timeoutConnection));
        }

        public HttpBuilder timeoutConnection(Integer timeoutConnection) {
            return this.timeoutConnection(timeoutConnection == null ? null : Long.valueOf(timeoutConnection.longValue()));
        }

        public HttpBuilder timeoutConnection(Long timeoutConnection) {
            this.builderTimeoutConnection = timeoutConnection;
            return this;
        }

        public HttpBuilder timeoutRead(String timeoutRead) {
            return this.timeoutRead(Durations.dehumanize(timeoutRead));
        }

        public HttpBuilder timeoutRead(Integer timeoutRead) {
            return this.timeoutRead(timeoutRead == null ? null : Long.valueOf(timeoutRead.longValue()));
        }

        public HttpBuilder timeoutRead(Long timeoutRead) {
            this.builderTimeoutRead = timeoutRead;
            return this;
        }

        public HttpBuilder followRedirects() {
            this.builderFollowRedirects = true;
            return this;
        }

        public HttpBuilder unfollowRedirects() {
            this.builderFollowRedirects = false;
            return this;
        }

        public HttpBuilder retries(Long retries, String timeBetween) {
            this.builderRetries = retries;
            this.builderRetriesTimebetween = timeBetween;
            return this;
        }

        public HttpBuilder timeoutThread() {
            this.builderTimeoutThread = true;
            return this;
        }

        public HttpBuilder body(String body) {
            return this.body(body, StandardCharsets.UTF_8);
        }

        public HttpBuilder body(String body, Charset charset) {
            this.builderBody = body == null ? null : body.getBytes(charset);
            return this;
        }

        public HttpBuilder body(byte[] body) {
            this.builderBody = body;
            return this;
        }

        public HttpBuilder header(String key, String value) {
            if (this.builderHeader == null) {
                this.builderHeader = new HashMap<String, String>();
            }
            this.builderHeader.put(key, value);
            return this;
        }

        public HttpBuilder headers(Map<String, String> headers) {
            if (this.builderHeader == null) {
                this.builderHeader = new HashMap<String, String>();
            }
            this.builderHeader.putAll(headers);
            return this;
        }

        public HttpBuilder parameter(String key, String ... values) {
            List<String> list = this.getParameterList(key);
            for (String value : values) {
                list.add(value);
            }
            return this;
        }

        public HttpBuilder param(String key, String ... values) {
            return this.parameter(key, values);
        }

        public HttpBuilder parameterMap(Map<String, String> parameters) {
            if (parameters != null) {
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    this.getParameterList(entry.getKey()).add(entry.getValue());
                }
            }
            return this;
        }

        public HttpBuilder parameterList(Map<String, List<String>> parameters) {
            if (parameters != null) {
                for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                    List<String> list = this.getParameterList(entry.getKey());
                    for (String value : entry.getValue()) {
                        list.add(value);
                    }
                }
            }
            return this;
        }

        private List<String> getParameterList(String key) {
            List<String> values;
            if (this.builderParameter == null) {
                this.builderParameter = new HashMap<String, List<String>>();
            }
            if ((values = this.builderParameter.get(key)) == null) {
                values = new ArrayList<String>();
                this.builderParameter.put(key, values);
            }
            return values;
        }

        public Response get() throws HttpClientException {
            return this.method(Method.GET);
        }

        public Future<Response> getAsync() {
            return this.callAsync(this::get);
        }

        public Response put() throws HttpClientException {
            return this.method(Method.PUT);
        }

        public Future<Response> putAsync() {
            return this.callAsync(this::put);
        }

        public Response post() throws HttpClientException {
            return this.method(Method.POST);
        }

        public Future<Response> postAsync() {
            return this.callAsync(this::post);
        }

        public Response delete() throws HttpClientException {
            return this.method(Method.DELETE);
        }

        public Future<Response> deleteAsync() {
            return this.callAsync(this::delete);
        }

        public Response head() throws HttpClientException {
            return this.method(Method.HEAD);
        }

        public Future<Response> headAsync() {
            return this.callAsync(this::head);
        }

        public Response trace() throws HttpClientException {
            return this.method(Method.TRACE);
        }

        public Future<Response> traceAsync() {
            return this.callAsync(this::trace);
        }

        public Response options() throws HttpClientException {
            return this.method(Method.OPTIONS);
        }

        public Future<Response> optionsAsync() {
            return this.callAsync(this::options);
        }

        public Future<Response> methodAsync(Method method) {
            return this.callAsync(() -> this.method(method));
        }

        public Response method(Method method) throws HttpClientException {
            HttpClient client = this.builderClient == null ? new CommonHttpClient() : this.builderClient;
            HttpOptions options = new HttpOptions();
            options.setTimeoutConnection((Long)ObjectUtils.defaultIfNull((Object)this.builderTimeoutConnection, (Object)this.builderTimeout));
            options.setTimeoutRead((Long)ObjectUtils.defaultIfNull((Object)this.builderTimeoutRead, (Object)this.builderTimeout));
            options.enableAuthorization(this.builderUsername, this.builderPassword);
            options.enableProxy(this.builderProxy);
            options.enableRetries(this.builderRetries, this.builderRetriesTimebetween);
            options.enableFollowRedirects(this.builderFollowRedirects);
            options.enableTimeoutThread(this.builderTimeoutThread);
            return client.request(this.builderResource, method, this.builderHeader, this.builderParameter, this.builderBody, options);
        }

        protected Future<Response> callAsync(Callable<Response> callable) {
            FutureTask<Response> task = new FutureTask<Response>(callable);
            new Thread(task).start();
            return task;
        }

        public String toUrlString() {
            return UrlConstruction.appendParameters(this.builderResource, this.builderParameter);
        }
    }
}

