/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net.flux;

import com.google.common.io.BaseEncoding;
import de.galan.commons.logging.Logr;
import de.galan.commons.net.flux.HttpClient;
import de.galan.commons.net.flux.HttpClientException;
import de.galan.commons.net.flux.HttpOptions;
import de.galan.commons.net.flux.Method;
import de.galan.commons.net.flux.Response;
import de.galan.commons.net.flux.UrlConstruction;
import de.galan.commons.time.Durations;
import de.galan.commons.time.Sleeper;
import de.galan.commons.util.Retryable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class CommonHttpClient
implements HttpClient {
    private static final Logger LOG = Logr.get();

    public Response request(String resource) throws HttpClientException {
        return this.request(resource, null, null, null, null, null);
    }

    public Response request(String protocol, String host, Integer port, String path, Method method, Map<String, String> extraHeader, Map<String, List<String>> parameters, byte[] body) throws HttpClientException {
        String buildUrl = UrlConstruction.constructResource(protocol, host, port, path);
        return this.request(buildUrl, method, extraHeader, parameters, body, null);
    }

    @Override
    public Response request(String resource, Method method, Map<String, String> extraHeader, Map<String, List<String>> parameters, byte[] body, HttpOptions options) throws HttpClientException {
        URL url;
        HttpOptions opts = options != null ? options : new HttpOptions();
        try {
            url = new URL(UrlConstruction.appendParameters(resource, parameters));
        }
        catch (MalformedURLException muex) {
            throw new HttpClientException("URL invalid", muex);
        }
        try {
            String timeBetween = opts.getTimeBetweenRetries() == null ? null : Durations.humanize(opts.getTimeBetweenRetries());
            return Retryable.retry(opts.getRetriesCount()).timeToWait(timeBetween).call(() -> this.request(method, extraHeader, body, url, opts));
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause() instanceof HttpClientException) {
                throw (HttpClientException)ex.getCause();
            }
            throw new HttpClientException("Failed requesting " + url + " after " + opts.getRetriesCount() + " retries", ex);
        }
    }

    protected Response request(Method method, Map<String, String> extraHeader, byte[] body, URL url, HttpOptions options) throws HttpClientException {
        Method scopeMethod = method;
        Map<String, String> header = extraHeader;
        int statusCode = 0;
        String contentEncoding = null;
        String contentType = null;
        InputStream is = null;
        HashMap<String, String> headerFields = new HashMap<String, String>();
        if (body != null && Method.DELETE.equals((Object)scopeMethod)) {
            scopeMethod = Method.POST;
            if (header == null) {
                header = new HashMap<String, String>();
            }
            header.put("X-HTTP-Method-Override", Method.DELETE.name());
        }
        LOG.debug("Requesting url {}: {} - headers {} - body {}", (Object)method, (Object)url, header, (Object)(body != null && body.length > 0 ? 1 : 0));
        HttpURLConnection connection = this.openConnection(url, options);
        this.initConnection(header, connection, options);
        try {
            connection.setRequestMethod(scopeMethod == null ? Method.GET.name() : scopeMethod.name());
            if (body != null) {
                connection.getOutputStream().write(body);
            }
            statusCode = connection.getResponseCode();
            contentEncoding = connection.getContentEncoding();
            contentType = connection.getContentType();
            for (String key : connection.getHeaderFields().keySet()) {
                headerFields.put(key, connection.getHeaderField(key));
            }
            try {
                is = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            throw new HttpClientException("Data could not be queried (" + ex.getClass().getSimpleName() + ": " + ex.getMessage() + ")", ex);
        }
        return new Response(connection, is, statusCode, contentEncoding, contentType, headerFields);
    }

    private void initConnection(Map<String, String> extraHeader, HttpURLConnection connection, HttpOptions options) {
        this.putAuthorization(connection, "Authorization", options.getAuthorizationUsername(), options.getAuthorizationPassword());
        connection.setConnectTimeout(options.getTimeoutConnection().intValue());
        connection.setReadTimeout(options.getTimeoutRead().intValue());
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(options.getFollowRedirects());
        if (extraHeader != null) {
            for (String key : extraHeader.keySet()) {
                connection.setRequestProperty(key, extraHeader.get(key));
            }
        }
        if (options.getTimeoutThread().booleanValue()) {
            this.startTimeoutThread(connection, options);
        }
    }

    private HttpURLConnection openConnection(URL url, HttpOptions options) throws HttpClientException {
        HttpURLConnection connection = null;
        try {
            if (options.isProxyEnabled()) {
                Proxy javaProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(options.getProxy().getIp(), options.getProxy().getPort()));
                connection = (HttpURLConnection)url.openConnection(javaProxy);
                if (options.getProxy().hasAuthentication()) {
                    if (HttpsURLConnection.class.isAssignableFrom(connection.getClass())) {
                        Authenticator.setDefault(this.createAuthenticator(options));
                    } else {
                        this.putAuthorization(connection, "Proxy-Authorization", options.getProxy().getUsername(), options.getProxy().getPassword());
                    }
                }
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
        }
        catch (IOException ex) {
            throw new HttpClientException("connection could not be opened", ex);
        }
        return connection;
    }

    protected Authenticator createAuthenticator(final HttpOptions options) {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (StringUtils.equalsIgnoreCase((CharSequence)this.getRequestingScheme(), (CharSequence)"basic") && StringUtils.equalsIgnoreCase((CharSequence)this.getRequestingURL().getProtocol(), (CharSequence)"https") && this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                    return new PasswordAuthentication(options.getProxy().getUsername(), options.getProxy().getPassword().toCharArray());
                }
                return super.getPasswordAuthentication();
            }
        };
    }

    protected void putAuthorization(URLConnection connection, String header, String username, String password) {
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            String pair = username + ":" + password;
            String encodedAuthorization = StringUtils.trim((String)BaseEncoding.base64().encode(pair.getBytes(StandardCharsets.UTF_8)));
            connection.setRequestProperty(header, "Basic " + encodedAuthorization);
        }
    }

    protected void startTimeoutThread(HttpURLConnection connection, HttpOptions options) {
        TimeoutThread tt = new TimeoutThread(connection, (int)(options.getTimeoutConnection() + options.getTimeoutRead()));
        tt.start();
    }

    public static class TimeoutThread
    extends Thread {
        private final HttpURLConnection connection;
        private final Integer timeout;

        public TimeoutThread(HttpURLConnection connection, Integer timeout) {
            this.connection = connection;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            Sleeper.sleep(this.timeout + 1000);
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }
}

