/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UrlUtil {
    public static String encode(String value, Charset charset) {
        try {
            return URLEncoder.encode(value, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Characterset is not supported.");
        }
    }

    public static String encode(String value) {
        return UrlUtil.encode(value, StandardCharsets.UTF_8);
    }

    public static String decode(String value, Charset charset) {
        try {
            return URLDecoder.decode(value, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Characterset is not supported.");
        }
    }

    public static String decode(String value) {
        return UrlUtil.decode(value, StandardCharsets.UTF_8);
    }
}

