/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum MimeType {
    TEXT_HTML("text/html", "html, htm, shtml"),
    TEXT_CSS("text/css", "css"),
    TEXT_XML("text/xml", "xml", "rss"),
    TEXT_PLAIN("text/plain", "txt"),
    TEXT_MATHML("text/mathml", "mml"),
    TEXT_J2ME_JAD("text/vnd.sun.j2me.app-descriptor", "jad"),
    TEXT_WML("text/vnd.wap.wml", "wml"),
    TEXT_HTC("text/x-component", "htc"),
    IMAGE_GIF("image/gif", "gif"),
    IMAGE_JPEG("image/jpeg", "jpg", "jpeg"),
    IMAGE_PNG("image/png", "png"),
    IMAGE_TIFF("image/tiff", "tiff", "tif"),
    IMAGE_WBMP("image/vnd.wap.wbmp", "wbmp"),
    IMAGE_ICO("image/x-icon", "ico"),
    IMAGE_JNG("image/x-jng", "jng"),
    IMAGE_BMP("image/x-ms-bmp", "bmp"),
    IMAGE_SVG("image/svg+xml", "svg"),
    APPLICATION_JSON("application/json", "json"),
    APPLICATION_JAVASCRIPT("application/x-javascript", "js"),
    APPLICATION_ATOM("application/atom+xml", "atom"),
    APPLICATION_JAR("application/java-archive", "jar", "war", "ear", "sar"),
    APPLICATION_HQX("application/mac-binhex40", "hqx"),
    APPLICATION_MSWORD("application/msword", "doc"),
    APPLICATION_MSEXCEL("application/vnd.ms-excel", "xls"),
    APPLICATION_MSPOWERPOINT("application/vnd.ms-powerpoint", "ppt"),
    APPLICATION_PDF("application/pdf", "pdf"),
    APPLICATION_POSTSCRIPT("application/postscript", "ps", "eps", "ai"),
    APPLICATION_RTF("application/rtf", "rtf"),
    APPLICATION_ZIP("application/zip", "zip"),
    APPLICATION_WMLC("application/vnd.wap.wmlc", "wmlc"),
    APPLICATION_XHTML("application/vnd.wap.xhtml+xml", "xhtml"),
    APPLICATION_COCOA("application/x-cocoa", "cco"),
    APPLICATION_JARDIFF("application/x-java-archive-diff", "jardiff"),
    APPLICATION_JNLP("application/x-java-jnlp-file", "jnlp"),
    APPLICATION_RUN("application/x-makeself", "run"),
    APPLICATION_PERL("application/x-perl", "pl", "pm"),
    APPLICATION_PALM("application/x-pilot", "prc", "pdb"),
    APPLICATION_RAR("application/x-rar-compressed", "rar"),
    APPLICATION_RPM("application/x-redhat-package-manager", "rpm"),
    APPLICATION_SEA("application/x-sea", "sea"),
    APPLICATION_SHOCKWAVE("application/x-shockwave-flash", "swf"),
    APPLICATION_SIT("application/x-stuffit", "sit"),
    APPLICATION_TCL("application/x-tcl", "tcl", "tk"),
    APPLICATION_CACERT("application/x-x509-ca-cert", "der", "pem", "crt"),
    APPLICATION_XPINSTALL("application/x-xpinstall", "xpi"),
    APPLICATION_JAVA_SERIALIZED("application/x-java-serialized-object", new String[0]),
    APPLICATION_OCTETSTREAM("application/octet-stream", "bin", "exe", "dll", "deb", "dmg", "eot", "iso", "img", "msi", "msp", "msm"),
    APPLICATION_GZIP("application/x-gzip", "gz", "gzip"),
    AUDIO_MIDI("audio/midi", "mid", "midi", "kar"),
    AUDIO_MPEG("audio/mpeg", "mp3"),
    AUDIO_REALAUDIO("audio/x-realaudio", "ra"),
    VIDEO_3GPP("video/3gpp", "3gpp", "3gp"),
    VIDEO_MPEG("video/mpeg", "mpeg", "mpg"),
    VIDEO_QUICKTIME("video/quicktime", "mov", "qt"),
    VIDEO_FLV("video/x-flv", "flv"),
    VIDEO_MNG("video/x-mng", "mng"),
    VIDEO_MP4("video/mp4", "mp4", "divx"),
    VIDEO_ASF("video/x-ms-asf", "asx", "asf"),
    VIDEO_WMV("video/x-ms-wmv", "wmv"),
    VIDEO_AVI("video/x-msvideo", "avi"),
    VIDEO_M4V("video/x-m4v", "m4v");

    private static final Map<String, MimeType> MIME_TYPES_BY_EXTENSION;
    private String mimeType;
    private final List<String> fileExtensions = new ArrayList<String>();

    private MimeType(String mimeType, String ... fileExtension) {
        this.mimeType = mimeType;
        for (String extension : fileExtension) {
            this.fileExtensions.add(extension);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMimeType());
        if (!this.getFileExtensions().isEmpty()) {
            builder.append(" (");
            int count = 0;
            for (String extension : this.getFileExtensions()) {
                if (count++ == 1) {
                    builder.append(", ");
                }
                builder.append(extension);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public static MimeType getMimeType(String extension) {
        MimeType result = null;
        if (extension != null) {
            result = MIME_TYPES_BY_EXTENSION.get(extension.toLowerCase());
        }
        return result;
    }

    static {
        MIME_TYPES_BY_EXTENSION = new HashMap<String, MimeType>();
        for (MimeType type : MimeType.values()) {
            for (String extension : type.getFileExtensions()) {
                MIME_TYPES_BY_EXTENSION.put(extension, type);
            }
        }
    }
}

