/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net;

import com.google.common.base.Splitter;
import de.galan.commons.logging.Logr;
import de.galan.commons.net.CommonProxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class CommonProxyParser {
    private static final Logger LOG = Logr.get();

    public CommonProxy parse(String proxy) {
        return this.parse(proxy, CommonProxy.DEFAULT_PORT);
    }

    public CommonProxy parse(String proxy, Integer defaultPort) {
        try {
            URI uri = new URI("http", "//" + proxy, null);
            URL url = uri.toURL();
            String host = url.getHost();
            if (StringUtils.isBlank((CharSequence)host)) {
                throw new MalformedURLException("host could not be parsed");
            }
            int portUrl = url.getPort();
            int port = portUrl < 1 || portUrl > 65535 ? defaultPort : portUrl;
            String userInfo = url.getUserInfo();
            String username = null;
            String password = null;
            if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                List splits = Splitter.on((String)":").trimResults().splitToList((CharSequence)userInfo);
                if (splits.size() > 2) {
                    throw new MalformedURLException("URL Authentication (UserInfo) invalid");
                }
                if (splits.size() >= 1) {
                    username = StringUtils.trimToNull((String)((String)splits.get(0)));
                    if (splits.size() == 2) {
                        password = StringUtils.trimToNull((String)((String)splits.get(1)));
                    }
                }
            }
            return new CommonProxy(host, port, username, password);
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOG.info("Invalid proxy given: {}", (Object)proxy);
            return null;
        }
    }
}

