/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.net;

import de.galan.commons.net.CommonProxyParser;
import org.apache.commons.lang3.StringUtils;

public class CommonProxy {
    static final Integer DEFAULT_PORT = 80;
    static final CommonProxyParser PARSER = new CommonProxyParser();
    private String username;
    private String password;
    private String ip;
    private Integer port;

    public static CommonProxy parse(String proxy) {
        return PARSER.parse(proxy, DEFAULT_PORT);
    }

    public CommonProxy(String ip) {
        this(ip, null, null, null);
    }

    public CommonProxy(String ip, Integer port) {
        this(ip, port, null, null);
    }

    public CommonProxy(String ip, Integer port, String username, String password) {
        this.username = username;
        this.password = password;
        this.ip = ip;
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password);
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port == null ? DEFAULT_PORT : this.port;
    }

    public String toString() {
        String result = null;
        if (!StringUtils.isBlank((CharSequence)this.getIp())) {
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.getUsername())) {
                builder.append(this.getUsername());
                if (StringUtils.isNotBlank((CharSequence)this.getPassword())) {
                    builder.append(":");
                    builder.append(this.getPassword());
                }
                builder.append("@");
            }
            builder.append(this.getIp());
            builder.append(":");
            builder.append(this.getPort());
            result = builder.toString();
        }
        return result;
    }
}

