/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.logging;

import com.google.common.collect.Sets;
import de.galan.commons.logging.MetaContext;
import de.galan.commons.logging.PayloadContextMessage;
import de.galan.commons.logging.PayloadContextMessageFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;

public class Say {
    static final String JSON_FIELD = "payload";
    private static final StackWalker WALKER = StackWalker.getInstance(Sets.newHashSet((Object[])new StackWalker.Option[]{StackWalker.Option.RETAIN_CLASS_REFERENCE}));
    private static ContextBuilder builder;

    protected static Message payload(Object message, Object[] arguments, Throwable throwable) {
        return new PayloadContextMessage(message == null ? null : message.toString(), arguments, throwable);
    }

    protected static void log(Level level, Class<?> callerClass, Object message, Throwable throwable, Object ... args) {
        Message payload = Say.payload(message, args, throwable);
        payload.getFormattedMessage();
        if (MetaContext.hasMeta()) {
            ThreadContext.put((String)JSON_FIELD, (String)MetaContext.toJson());
            MetaContext.clear();
        }
        Logger logger = LogManager.getLogger(callerClass, (MessageFactory)PayloadContextMessageFactory.INSTANCE);
        logger.log(level, payload, payload.getThrowable());
        if (ThreadContext.getContext() != null && ThreadContext.containsKey((String)JSON_FIELD)) {
            ThreadContext.remove((String)JSON_FIELD);
        }
    }

    public static ContextBuilder f(String key, Object value) {
        return builder.field(key, value);
    }

    public static ContextBuilder field(String key, Object value) {
        return builder.field(key, value);
    }

    public static void trace(Object message) {
        Say.log(Level.TRACE, WALKER.getCallerClass(), message, null, null);
    }

    public static void trace(Object message, Object ... args) {
        Say.log(Level.TRACE, WALKER.getCallerClass(), message, null, args);
    }

    public static void trace(Object message, Throwable throwable) {
        Say.log(Level.TRACE, WALKER.getCallerClass(), message, throwable, null);
    }

    public static void trace(Object message, Throwable throwable, Object ... args) {
        Say.log(Level.TRACE, WALKER.getCallerClass(), message, throwable, args);
    }

    public static void debug(Object message) {
        Say.log(Level.DEBUG, WALKER.getCallerClass(), message, null, null);
    }

    public static void debug(Object message, Object ... args) {
        Say.log(Level.DEBUG, WALKER.getCallerClass(), message, null, args);
    }

    public static void debug(Object message, Throwable throwable) {
        Say.log(Level.DEBUG, WALKER.getCallerClass(), message, throwable, null);
    }

    public static void debug(Object message, Throwable throwable, Object ... args) {
        Say.log(Level.DEBUG, WALKER.getCallerClass(), message, throwable, args);
    }

    public static void info(Object message) {
        Say.log(Level.INFO, WALKER.getCallerClass(), message, null, null);
    }

    public static void info(Object message, Object ... args) {
        Say.log(Level.INFO, WALKER.getCallerClass(), message, null, args);
    }

    public static void info(Object message, Throwable throwable) {
        Say.log(Level.INFO, WALKER.getCallerClass(), message, throwable, null);
    }

    public static void info(Object message, Throwable throwable, Object ... args) {
        Say.log(Level.INFO, WALKER.getCallerClass(), message, throwable, args);
    }

    public static void warn(Object message) {
        Say.log(Level.WARN, WALKER.getCallerClass(), message, null, null);
    }

    public static void warn(Object message, Object ... args) {
        Say.log(Level.WARN, WALKER.getCallerClass(), message, null, args);
    }

    public static void warn(Object message, Throwable throwable) {
        Say.log(Level.WARN, WALKER.getCallerClass(), message, throwable, null);
    }

    public static void warn(Object message, Throwable throwable, Object ... args) {
        Say.log(Level.WARN, WALKER.getCallerClass(), message, throwable, args);
    }

    public static void error(Object message) {
        Say.log(Level.ERROR, WALKER.getCallerClass(), message, null, null);
    }

    public static void error(Object message, Object ... args) {
        Say.log(Level.ERROR, WALKER.getCallerClass(), message, null, args);
    }

    public static void error(Object message, Throwable throwable) {
        Say.log(Level.ERROR, WALKER.getCallerClass(), message, throwable, null);
    }

    public static void error(Object message, Throwable throwable, Object ... args) {
        Say.log(Level.ERROR, WALKER.getCallerClass(), message, throwable, args);
    }

    public static void fatal(Object message) {
        Say.log(Level.FATAL, WALKER.getCallerClass(), message, null, null);
    }

    public static void fatal(Object message, Object ... args) {
        Say.log(Level.FATAL, WALKER.getCallerClass(), message, null, args);
    }

    public static void fatal(Object message, Throwable throwable) {
        Say.log(Level.FATAL, WALKER.getCallerClass(), message, throwable, null);
    }

    public static void fatal(Object message, Throwable throwable, Object ... args) {
        Say.log(Level.FATAL, WALKER.getCallerClass(), message, throwable, args);
    }

    public static void please() {
        Say.log(Level.INFO, WALKER.getCallerClass(), "You're welcome " + System.getProperty("user.name") + "!", null, null);
    }

    static {
        PayloadContextMessage.envSayFieldsEnclosed = !"false".equals(System.getenv("SAY_FIELDS_ENCLOSED"));
        builder = new ContextBuilder();
    }

    public static class ContextBuilder {
        public ContextBuilder f(String key, Object value) {
            return this.field(key, value);
        }

        public ContextBuilder field(String key, Object value) {
            MetaContext.put(key, value);
            return this;
        }

        public void trace(Object message) {
            Say.log(Level.TRACE, WALKER.getCallerClass(), message, null, null);
        }

        public void trace(Object message, Object ... args) {
            Say.log(Level.TRACE, WALKER.getCallerClass(), message, null, args);
        }

        public void trace(Object message, Throwable throwable) {
            Say.log(Level.TRACE, WALKER.getCallerClass(), message, throwable, null);
        }

        public void trace(Object message, Throwable throwable, Object ... args) {
            Say.log(Level.TRACE, WALKER.getCallerClass(), message, throwable, args);
        }

        public void debug(Object message) {
            Say.log(Level.DEBUG, WALKER.getCallerClass(), message, null, null);
        }

        public void debug(Object message, Object ... args) {
            Say.log(Level.DEBUG, WALKER.getCallerClass(), message, null, args);
        }

        public void debug(Object message, Throwable throwable) {
            Say.log(Level.DEBUG, WALKER.getCallerClass(), message, throwable, null);
        }

        public void debug(Object message, Throwable throwable, Object ... args) {
            Say.log(Level.DEBUG, WALKER.getCallerClass(), message, throwable, args);
        }

        public void info(Object message) {
            Say.log(Level.INFO, WALKER.getCallerClass(), message, null, null);
        }

        public void info(Object message, Object ... args) {
            Say.log(Level.INFO, WALKER.getCallerClass(), message, null, args);
        }

        public void info(Object message, Throwable throwable) {
            Say.log(Level.INFO, WALKER.getCallerClass(), message, throwable, null);
        }

        public void info(Object message, Throwable throwable, Object ... args) {
            Say.log(Level.INFO, WALKER.getCallerClass(), message, throwable, args);
        }

        public void warn(Object message) {
            Say.log(Level.WARN, WALKER.getCallerClass(), message, null, null);
        }

        public void warn(Object message, Object ... args) {
            Say.log(Level.WARN, WALKER.getCallerClass(), message, null, args);
        }

        public void warn(Object message, Throwable throwable) {
            Say.log(Level.WARN, WALKER.getCallerClass(), message, throwable, null);
        }

        public void warn(Object message, Throwable throwable, Object ... args) {
            Say.log(Level.WARN, WALKER.getCallerClass(), message, throwable, args);
        }

        public void error(Object message) {
            Say.log(Level.ERROR, WALKER.getCallerClass(), message, null, null);
        }

        public void error(Object message, Object ... args) {
            Say.log(Level.ERROR, WALKER.getCallerClass(), message, null, args);
        }

        public void error(Object message, Throwable throwable) {
            Say.log(Level.ERROR, WALKER.getCallerClass(), message, throwable, null);
        }

        public void error(Object message, Throwable throwable, Object ... args) {
            Say.log(Level.ERROR, WALKER.getCallerClass(), message, throwable, args);
        }

        public void fatal(Object message) {
            Say.log(Level.FATAL, WALKER.getCallerClass(), message, null, null);
        }

        public void fatal(Object message, Object ... args) {
            Say.log(Level.FATAL, WALKER.getCallerClass(), message, null, args);
        }

        public void fatal(Object message, Throwable throwable) {
            Say.log(Level.FATAL, WALKER.getCallerClass(), message, throwable, null);
        }

        public void fatal(Object message, Throwable throwable, Object ... args) {
            Say.log(Level.FATAL, WALKER.getCallerClass(), message, throwable, args);
        }
    }
}

