/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.logging;

import org.apache.logging.log4j.message.Message;

public class PayloadMessage
implements Message {
    private static final String[] EMPTY_ARGUMENTS = new String[0];
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char KV_SEPARATOR = ':';
    static boolean envSayFieldEnclosed = true;
    private transient String formattedMessage;
    private final String paramMessagePattern;
    private String[] arguments;
    private Object[] paramArguments;
    private int[] indexes;
    private boolean includeIdentifier;
    private String errorMessage;
    private transient Throwable throwable;

    public PayloadMessage(String messagePattern, Object[] argumentsObject) {
        this(messagePattern, argumentsObject, false, null);
    }

    public PayloadMessage(String messagePattern, Object[] argumentsObject, boolean includeIdentifier, Throwable throwable) {
        this.paramArguments = argumentsObject == null ? EMPTY_ARGUMENTS : argumentsObject;
        this.paramMessagePattern = messagePattern;
        this.includeIdentifier = includeIdentifier;
        this.throwable = throwable;
        this.parseMessage(messagePattern);
        this.arguments = this.argumentsToStrings(this.paramArguments);
    }

    protected String[] argumentsToStrings(Object[] argumentsObject) {
        int patternArguments = this.getPatternAmountArguments();
        if (argumentsObject.length == 0 && patternArguments == 0) {
            return EMPTY_ARGUMENTS;
        }
        Object[] objArgs = argumentsObject;
        int realLength = objArgs.length;
        if (this.throwable != null && patternArguments == realLength + 1) {
            Object[] temp = new Object[objArgs.length + 1];
            System.arraycopy(objArgs, 0, temp, 0, objArgs.length);
            temp[temp.length - 1] = this.throwable;
            this.throwable = null;
            objArgs = temp;
            realLength = objArgs.length;
        } else if (realLength > 0 && realLength - 1 == patternArguments && Throwable.class.isAssignableFrom(objArgs[realLength - 1].getClass())) {
            if (this.throwable == null) {
                this.throwable = (Throwable)objArgs[realLength - 1];
            }
            Object[] withoutThrowable = new Object[--realLength];
            System.arraycopy(objArgs, 0, withoutThrowable, 0, realLength);
            this.paramArguments = withoutThrowable;
        }
        String[] strArgs = new String[realLength];
        for (int i = 0; i < realLength; ++i) {
            strArgs[i] = this.convertToString(objArgs[i]);
        }
        return strArgs;
    }

    protected int getPatternAmountArguments() {
        return this.indexes == null || this.indexes.length == 0 ? 0 : this.indexes.length / 2;
    }

    protected void parseMessage(String messagePattern) {
        if (messagePattern == null || messagePattern.length() == 0) {
            return;
        }
        int startPosition = -1;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (startPosition != -1) {
                if (curChar != '}') continue;
                this.indexes[this.indexes.length - 1] = i;
                startPosition = -1;
                continue;
            }
            if (curChar != '{') continue;
            if (this.indexes == null) {
                this.indexes = new int[2];
            } else {
                int[] next = new int[this.indexes.length + 2];
                System.arraycopy(this.indexes, 0, next, 0, this.indexes.length);
                this.indexes = next;
            }
            this.indexes[this.indexes.length - 2] = i + 1;
            startPosition = i;
        }
        if (startPosition != -1) {
            this.errorMessage = "Invalid pattern, curly brace left unclosed.";
        }
    }

    protected String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.errorMessage != null ? this.errorMessage : this.formatMessage(this.paramMessagePattern, this.arguments);
        }
        return this.formattedMessage;
    }

    private String formatMessage(String pattern, String[] args) {
        if (pattern == null) {
            return pattern;
        }
        int amount = this.getPatternAmountArguments();
        if (this.arguments.length < amount) {
            this.errorMessage = "Invalid amount of arguments (only " + this.paramArguments.length + " available, " + (amount - this.paramArguments.length) + " missing)";
        }
        if (this.arguments.length > amount) {
            this.errorMessage = "Invalid amount of arguments (" + this.paramArguments.length + " given but only " + amount + " used in pattern)";
        }
        if (amount == 0) {
            return pattern;
        }
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        int delimLengthRemoval = envSayFieldEnclosed ? 0 : 1;
        StringBuilder builder = new StringBuilder();
        int indexPosition = 0;
        int argumentWithoutIdentifier = 0;
        for (int i = 0; i < amount; ++i) {
            int factor = i * 2;
            if (this.includeIdentifier) {
                builder.append(this.paramMessagePattern.substring(indexPosition, this.indexes[factor + 1]));
                if (this.indexes[factor + 1] - this.indexes[factor] == 0) {
                    builder.append(argumentWithoutIdentifier++);
                }
                builder.append(':');
            } else {
                builder.append(this.paramMessagePattern.substring(indexPosition, this.indexes[factor] - delimLengthRemoval));
            }
            builder.append(this.arguments[i]);
            indexPosition = this.indexes[factor + 1] + delimLengthRemoval;
        }
        builder.append(this.paramMessagePattern.substring(indexPosition, this.paramMessagePattern.length()));
        return builder.toString();
    }

    public String getFormat() {
        return this.paramMessagePattern;
    }

    public Object[] getParameters() {
        return this.paramArguments;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

