/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.logging;

import de.galan.commons.logging.MetaContext;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.message.Message;

public class PayloadContextMessage
implements Message {
    private static final String[] EMPTY_ARGUMENTS = new String[0];
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final String DATE_FORMAT_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private static final FastDateFormat FDF = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)TIMEZONE_UTC);
    static boolean envSayFieldsEnclosed = true;
    private transient String formattedMessage;
    private transient Throwable throwable;
    private final String paramMessagePattern;
    private String[] argsString;
    private Object[] argsObject;
    private int[] indexes;
    private String errorMessage;

    public PayloadContextMessage(String messagePattern, Object[] argumentsObject) {
        this(messagePattern, argumentsObject, null);
    }

    public PayloadContextMessage(String messagePattern, Object[] argumentsObject, Throwable throwable) {
        this.throwable = throwable;
        this.paramMessagePattern = messagePattern;
        this.parseMessage(messagePattern);
        this.argsObject = this.determineArgumentsObject(argumentsObject);
        this.argsString = this.argumentsToStrings(this.argsObject);
        this.addErrorFields();
    }

    private Object[] determineArgumentsObject(Object[] argumentsObject) {
        int patternAmountArgs;
        Object[] result = argumentsObject == null ? EMPTY_ARGUMENTS : argumentsObject;
        if (result.length != (patternAmountArgs = this.getPatternAmountArguments())) {
            if (result.length < patternAmountArgs) {
                if (patternAmountArgs == result.length + 1 && this.throwable != null) {
                    Object[] temp = new Object[result.length + 1];
                    System.arraycopy(result, 0, temp, 0, result.length);
                    temp[temp.length - 1] = this.throwable;
                    this.throwable = null;
                    result = temp;
                }
            } else if (result.length > patternAmountArgs && result.length > 0 && result.length - 1 == patternAmountArgs && Throwable.class.isAssignableFrom(result[result.length - 1].getClass())) {
                if (this.throwable == null) {
                    this.throwable = (Throwable)result[result.length - 1];
                }
                Object[] withoutThrowable = new Object[result.length - 1];
                System.arraycopy(result, 0, withoutThrowable, 0, result.length - 1);
                result = withoutThrowable;
            }
        }
        return result;
    }

    protected void parseMessage(String messagePattern) {
        if (messagePattern == null || messagePattern.length() == 0) {
            return;
        }
        int startPosition = -1;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (startPosition != -1) {
                if (curChar != '}') continue;
                this.indexes[this.indexes.length - 1] = i;
                startPosition = -1;
                continue;
            }
            if (curChar != '{') continue;
            if (this.indexes == null) {
                this.indexes = new int[2];
            } else {
                int[] next = new int[this.indexes.length + 2];
                System.arraycopy(this.indexes, 0, next, 0, this.indexes.length);
                this.indexes = next;
            }
            this.indexes[this.indexes.length - 2] = i + 1;
            startPosition = i;
        }
        if (startPosition != -1) {
            this.errorMessage = "Invalid pattern, curly brace left unclosed.";
        }
    }

    protected String[] argumentsToStrings(Object[] argumentsObject) {
        if (argumentsObject.length == 0 && this.getPatternAmountArguments() == 0) {
            return EMPTY_ARGUMENTS;
        }
        String[] result = new String[argumentsObject.length];
        for (int i = 0; i < argumentsObject.length; ++i) {
            result[i] = this.convertToString(argumentsObject[i]);
        }
        return result;
    }

    protected int getPatternAmountArguments() {
        return this.indexes == null || this.indexes.length == 0 ? 0 : this.indexes.length / 2;
    }

    protected String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Date) {
            return FDF.format((Date)object);
        }
        return object.toString();
    }

    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.errorMessage != null ? this.errorMessage : this.formatMessage(this.paramMessagePattern, this.argsString);
        }
        return this.formattedMessage;
    }

    private String formatMessage(String pattern, String[] args) {
        if (pattern == null) {
            return pattern;
        }
        int amount = this.getPatternAmountArguments();
        if (amount == 0) {
            return pattern;
        }
        if (this.argsString.length < amount) {
            this.errorMessage = "Invalid amount of arguments (only " + this.argsObject.length + " available, " + (amount - this.argsObject.length) + " missing). Pattern: '" + pattern + "'";
        } else if (this.argsString.length > amount) {
            this.errorMessage = "Invalid amount of arguments (" + this.argsObject.length + " given but only " + amount + " used). Pattern: '" + pattern + "'";
        }
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        int delimLengthRemoval = envSayFieldsEnclosed ? 0 : 1;
        StringBuilder builder = new StringBuilder();
        int indexPosition = 0;
        for (int i = 0; i < amount; ++i) {
            int factor = i * 2;
            builder.append(this.paramMessagePattern.substring(indexPosition, this.indexes[factor] - delimLengthRemoval));
            if (this.indexes[factor + 1] > this.indexes[factor] && this.argsString[i] != null) {
                String tcName = this.paramMessagePattern.substring(this.indexes[factor], this.indexes[factor + 1]);
                MetaContext.put(tcName, this.argsObject[i]);
            }
            builder.append(this.argsString[i]);
            indexPosition = this.indexes[factor + 1] + delimLengthRemoval;
        }
        builder.append(this.paramMessagePattern.substring(indexPosition, this.paramMessagePattern.length()));
        return builder.toString();
    }

    private void addErrorFields() {
        if (this.throwable != null) {
            MetaContext.putIfAbsent("error_class", this.throwable.getClass());
            MetaContext.putIfAbsent("error_message", this.throwable.getMessage());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.throwable);
            if (rootCause != null && rootCause.getClass() != this.throwable.getClass()) {
                MetaContext.putIfAbsent("root_error_class", rootCause.getClass());
                MetaContext.putIfAbsent("root_error_message", rootCause.getMessage());
            }
        }
    }

    public String getFormat() {
        return this.paramMessagePattern;
    }

    public Object[] getParameters() {
        return this.argsObject;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

