/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.logging;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.jul.LogManager;

public class BootstrapLogger {
    public static final String LOG4J2_XML = "log4j2.xml";
    private static final String JUL_MANAGER = "java.util.logging.manager";
    private static final String LOG4J2_PROPERTY = "log4j.configurationFile";

    public void initializeLogger(String log4jConfigurationPath) {
        File log4jFile;
        if (StringUtils.isBlank((CharSequence)System.getProperty(LOG4J2_PROPERTY)) && !StringUtils.isBlank((CharSequence)log4jConfigurationPath) && (log4jFile = new File(log4jConfigurationPath)).exists()) {
            Object log4jUrl;
            try {
                log4jUrl = log4jFile.toURI().toURL().toString();
            }
            catch (MalformedURLException ex) {
                log4jUrl = "file:" + log4jConfigurationPath;
            }
            System.setProperty(LOG4J2_PROPERTY, (String)log4jUrl);
        }
        System.setProperty(JUL_MANAGER, LogManager.class.getName());
    }
}

