/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.io.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public class GzipAwareInputStream
extends InputStream {
    boolean compressed = false;
    private PushbackInputStream pushback;
    private InputStream selected;
    private boolean decompress;

    public GzipAwareInputStream(InputStream in) {
        this(in, true);
    }

    public GzipAwareInputStream(InputStream in, boolean decompress) {
        this.pushback = new PushbackInputStream(in, 2);
        this.decompress = decompress;
    }

    @Override
    public int read() throws IOException {
        if (this.selected == null) {
            this.checkHeader();
        }
        return this.selected.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.selected == null) {
            this.checkHeader();
        }
        return this.selected.read(b, off, len);
    }

    private void checkHeader() throws IOException {
        byte[] header = new byte[]{-1, -1};
        int read = this.pushback.read(header, 0, 2);
        boolean bl = this.compressed = header[0] == 31 && header[1] == -117;
        if (read > 0) {
            this.pushback.unread(header, 0, read);
        }
        this.selected = this.compressed && this.decompress ? new GZIPInputStream(this.pushback) : this.pushback;
    }

    public boolean isCompressed() throws IOException {
        if (this.selected == null) {
            this.checkHeader();
        }
        return this.compressed;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.selected == null) {
            this.checkHeader();
        }
        return this.selected.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.selected == null) {
            this.checkHeader();
        }
        return this.selected.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.selected == null) {
            this.checkHeader();
        }
        return this.selected.available();
    }

    @Override
    public void close() throws IOException {
        this.selected.close();
    }
}

