/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.io.streams;

import de.galan.commons.util.BOM;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BomAwareInputStream
extends PushbackInputStream {
    byte[] header;

    public BomAwareInputStream(InputStream in) {
        super(in, 3);
    }

    @Override
    public int read() throws IOException {
        if (this.header == null) {
            this.checkHeader();
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.header == null) {
            this.checkHeader();
        }
        return super.read(b, off, len);
    }

    private void checkHeader() throws IOException {
        this.header = new byte[]{-1, -1, -1};
        int nRead = this.read(this.header);
        if (nRead > 0 && !BOM.isUTF8(this.header)) {
            this.unread(this.header, 0, nRead);
        }
    }
}

