/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.io.file;

import com.google.common.base.Preconditions;
import de.galan.commons.io.file.FileListener;
import de.galan.commons.io.file.ProxyDirectoryListener;
import de.galan.commons.io.file.ProxyFileListener;
import de.galan.commons.logging.Logr;
import de.galan.commons.time.Sleeper;
import de.galan.commons.util.Generics;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class FilesystemObserver {
    private static final Logger LOG = Logr.get();
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    WatchService watcher;
    Map<WatchKey, Set<ProxyFileListener>> keysFileListener;
    Map<WatchKey, ProxyDirectoryListener> keysDirectoryListener;
    Thread watcherThread;

    public FilesystemObserver() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.keysFileListener = new HashMap<WatchKey, Set<ProxyFileListener>>();
            this.keysDirectoryListener = new HashMap<WatchKey, ProxyDirectoryListener>();
            this.watcherThread = this.createWatcherThread();
            this.start();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed initializing FilesystemObserver", ex);
        }
    }

    protected Thread createWatcherThread() {
        Thread thread = new Thread(() -> this.processEvents(), "FilesystemObserver-" + THREAD_COUNTER.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }

    public void start() {
        if (!this.watcherThread.isAlive()) {
            this.watcherThread = this.createWatcherThread();
            this.watcherThread.start();
        }
    }

    public void stop() {
        if (this.watcherThread.isAlive()) {
            this.watcherThread.interrupt();
            while (this.watcherThread.isAlive()) {
                Sleeper.sleep(5L);
            }
        }
    }

    protected void processEvents() {
        while (true) {
            WatchKey key = null;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException iex) {
                LOG.info("interrupted");
                return;
            }
            Set<ProxyFileListener> fileListeners = this.keysFileListener.get(key);
            ProxyDirectoryListener directoryListener = this.keysDirectoryListener.get(key);
            if (directoryListener != null || fileListeners != null && !fileListeners.isEmpty()) {
                List<WatchEvent<?>> events = key.pollEvents();
                for (WatchEvent<?> event : events) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent ev = (WatchEvent)Generics.cast(event);
                    Path path = (Path)ev.context();
                    if (fileListeners != null) {
                        fileListeners.forEach(fileListener -> this.notifyFileListener((ProxyFileListener)fileListener, kind, path));
                    }
                    this.notifyDirectoryListener(directoryListener, kind, path);
                }
            } else {
                LOG.info("WatchKey not recognized");
                continue;
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keysDirectoryListener.remove(key);
            if (this.keysDirectoryListener.isEmpty()) break;
        }
    }

    protected void notifyDirectoryListener(ProxyDirectoryListener proxyDirectoryListener, WatchEvent.Kind<?> kind, Path path) {
        if (proxyDirectoryListener != null) {
            File file = new File(proxyDirectoryListener.getDirectory(), path.getFileName().toString());
            LOG.info("dir: " + proxyDirectoryListener.getDirectory().getAbsolutePath() + ", file:" + file.getName());
            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                proxyDirectoryListener.notifyFileCreated(file);
                if (proxyDirectoryListener.isRecursive() && file.isDirectory()) {
                    try {
                        this.registerDirectoryListener((FileListener)proxyDirectoryListener, Paths.get(file.toURI()), proxyDirectoryListener.isRecursive());
                    }
                    catch (IOException ex) {
                        LOG.info("Unable to register new subdirectory {}/{}", (Object)proxyDirectoryListener.getDirectory().getAbsolutePath(), (Object)file.getName());
                    }
                }
            } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                proxyDirectoryListener.notifyFileChanged(file);
            } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                proxyDirectoryListener.notifyFileDeleted(file);
            }
        }
    }

    protected void notifyFileListener(ProxyFileListener fileListener, WatchEvent.Kind<?> kind, Path path) {
        if (fileListener != null && StringUtils.equals((CharSequence)path.getFileName().toString(), (CharSequence)fileListener.getFile().getName())) {
            LOG.info("kind: " + kind + ", file: " + fileListener.getFile().getAbsolutePath());
            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                fileListener.notifyFileCreated(fileListener.getFile());
            } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                fileListener.notifyFileChanged(fileListener.getFile());
            } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                fileListener.notifyFileDeleted(fileListener.getFile());
            }
        }
    }

    public void registerFileListener(FileListener fileListener, File file) throws IOException {
        Preconditions.checkNotNull((Object)fileListener, (Object)"FileListener is null");
        Preconditions.checkNotNull((Object)file, (Object)"File is null");
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0, (Object)"File in assumed to be a file, not a directory");
        File directory = file.getParentFile();
        Path path = Paths.get(directory.toURI());
        WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keysFileListener.computeIfAbsent(key, k -> new HashSet()).add(new ProxyFileListener(fileListener, file));
    }

    public void registerDirectoryListener(FileListener directoryListener, File directory, boolean recursive) throws IOException {
        Preconditions.checkNotNull((Object)directoryListener, (Object)"DirectoryListener is null");
        Preconditions.checkNotNull((Object)directory, (Object)"Directory is null");
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"Directory is assumed to be a directory, not a file");
        Path path = Paths.get(directory.toURI());
        this.registerDirectoryListener(directoryListener, path, recursive);
    }

    protected void registerDirectoryListener(final FileListener directoryListener, Path directory, final boolean recursive) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ProxyDirectoryListener listener = new ProxyDirectoryListener(directoryListener, dir.toFile(), recursive);
                FilesystemObserver.this.registerDirectoryListenerInternal(listener);
                return recursive ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
            }
        });
    }

    protected void registerDirectoryListenerInternal(ProxyDirectoryListener proxyDirectoryListener) throws IOException {
        File directory = proxyDirectoryListener.getDirectory();
        Path path = Paths.get(directory.toURI());
        WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keysDirectoryListener.put(key, proxyDirectoryListener);
    }
}

