/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.io.file;

import com.google.common.base.Preconditions;
import de.galan.commons.logging.Say;
import de.galan.commons.time.Instants;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.Objects;

public class FileSupport {
    public static void deleteFile(File file) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        Files.walk(file.toPath(), new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
    }

    public static boolean deleteFileQuiet(File file) {
        try {
            FileSupport.deleteFile(file);
        }
        catch (IOException ex) {
            Say.warn((Object)"Unable to delete directory", ex);
            return false;
        }
        return true;
    }

    public static void touch(File file) throws IOException {
        Objects.requireNonNull(file, "fileis null");
        FileSupport.touch(file.toPath());
    }

    public static void touch(Path path) throws IOException {
        Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((!path.toFile().isDirectory() ? 1 : 0) != 0, (Object)"path is a directory");
        if (Files.exists(path, new LinkOption[0])) {
            Files.setLastModifiedTime(path, FileTime.from(Instants.now()));
        } else {
            Files.createFile(path, new FileAttribute[0]);
        }
    }
}

