/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.collection;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SoftReferenceCache<T> {
    private Map<String, SoftReference<T>> cache = Collections.synchronizedMap(new HashMap());

    public void put(String key, T obj) {
        this.cache.put(key, new SoftReference<T>(obj));
    }

    public T get(String key) {
        SoftReference<T> ref = this.cache.get(key);
        if (ref == null) {
            return null;
        }
        T result = ref.get();
        if (result == null) {
            this.cache.remove(key);
        }
        return result;
    }
}

