/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.tape;

import de.fxnn.brainfuck.tape.OutOfTapeBoundsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class TapeSegment<T> {
    List<T> list;
    int index;
    @Nullable
    TapeSegment<T> previousSegment = null;
    @Nullable
    TapeSegment<T> nextSegment = null;

    public TapeSegment(int size, T initialValue) {
        this.list = new ArrayList<T>(Collections.nCopies(size, initialValue));
        this.moveToIndex(0);
    }

    public TapeSegment<T> atBeginning() {
        this.moveToIndex(0);
        return this;
    }

    public TapeSegment<T> atEnd() {
        this.moveToIndex(this.list.size() - 1);
        return this;
    }

    public void moveForward() throws OutOfTapeBoundsException {
        int newIndex = this.index + 1;
        if (newIndex >= this.list.size()) {
            throw new OutOfTapeBoundsException("Would move beyond end of tape segment [newIndex=" + newIndex + "]!");
        }
        this.moveToIndex(newIndex);
    }

    public void moveBackward() throws OutOfTapeBoundsException {
        int newIndex = this.index - 1;
        if (newIndex < 0) {
            throw new OutOfTapeBoundsException("Would move before start of tape segment [newIndex=" + newIndex + "]");
        }
        this.moveToIndex(newIndex);
    }

    protected void moveToIndex(int index) {
        this.index = index;
    }

    public T read() {
        return this.list.get(this.index);
    }

    public void write(T value) {
        this.list.set(this.index, value);
    }

    @Nullable
    public TapeSegment<T> getPreviousSegment() {
        return this.previousSegment;
    }

    public void setPreviousSegment(@Nullable TapeSegment<T> previousSegment) {
        this.previousSegment = previousSegment;
    }

    @Nullable
    public TapeSegment<T> getNextSegment() {
        return this.nextSegment;
    }

    public void setNextSegment(@Nullable TapeSegment<T> nextSegment) {
        this.nextSegment = nextSegment;
    }
}

