/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.tape;

import de.fxnn.brainfuck.tape.AbstractInfiniteTape;
import de.fxnn.brainfuck.tape.TapeEofBehaviour;
import de.fxnn.brainfuck.tape.TapeIOException;
import de.fxnn.brainfuck.tape.TapeSegment;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public class InfiniteSignedIntegerTape
extends AbstractInfiniteTape<Integer> {
    private static final int DEFAULT_TAPE_SEGMENT_SIZE = 1024;
    private static final int DEFAULT_VALUE = 0;
    private final TapeEofBehaviour eofBehaviour;

    public InfiniteSignedIntegerTape(TapeEofBehaviour eofBehaviour) {
        this.eofBehaviour = eofBehaviour;
    }

    @Override
    protected TapeSegment<Integer> createSegment() {
        return new TapeSegment<Integer>(1024, 0);
    }

    @Override
    public void increment() {
        this.write((Integer)this.read() + 1);
    }

    @Override
    public void decrement() {
        this.write((Integer)this.read() - 1);
    }

    @Override
    public void readTo(DataOutput output) throws TapeIOException {
        try {
            output.writeInt((Integer)this.read());
        }
        catch (IOException ex) {
            throw new TapeIOException("I/O error while writing from tape to output [" + output + "]: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void writeFrom(DataInput input) throws TapeIOException {
        try {
            this.write(input.readInt());
        }
        catch (EOFException ex) {
            this.write(this.eofBehaviour.getEofValue(this, input));
        }
        catch (IOException ex) {
            throw new TapeIOException("I/O error while reading from input [" + input + "] to tape: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isZero() {
        return (Integer)this.read() == 0;
    }
}

