/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.tape;

import de.fxnn.brainfuck.tape.AbstractInfiniteTape;
import de.fxnn.brainfuck.tape.TapeEofBehaviour;
import de.fxnn.brainfuck.tape.TapeIOException;
import de.fxnn.brainfuck.tape.TapeSegment;
import de.fxnn.util.UnicodeBuffers;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class InfiniteCharacterTape
extends AbstractInfiniteTape<Integer> {
    private static final int DEFAULT_TAPE_SEGMENT_SIZE = 1024;
    private static final Integer DEFAULT_VALUE = 0;
    private final Charset charset;
    private final CharsetDecoder charsetDecoder;
    private final TapeEofBehaviour eofBehaviour;

    public InfiniteCharacterTape(Charset charset, TapeEofBehaviour eofBehaviour) {
        this.charset = charset;
        this.charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.eofBehaviour = eofBehaviour;
    }

    @Override
    protected TapeSegment<Integer> createSegment() {
        return new TapeSegment<Integer>(1024, DEFAULT_VALUE);
    }

    @Override
    public void increment() {
        this.write(this.incrementCodePoint((Integer)this.read()));
    }

    private int incrementCodePoint(int value) {
        if (Character.isDefined(value + 1)) {
            return value + 1;
        }
        return 0;
    }

    @Override
    public void decrement() {
        this.write(this.decrementCodePoint((Integer)this.read()));
    }

    private int decrementCodePoint(int value) {
        if (Character.isDefined(value - 1)) {
            return value - 1;
        }
        return 0x10FFFF;
    }

    @Override
    public void readTo(DataOutput output) throws TapeIOException {
        try {
            Integer codePoint = (Integer)this.read();
            if (codePoint == -1) {
                codePoint = 0;
            }
            CharBuffer charBuffer = CharBuffer.wrap(Character.toChars(codePoint));
            ByteBuffer byteBuffer = this.charset.encode(charBuffer);
            UnicodeBuffers.skipByteOrderMarks(byteBuffer, UnicodeBuffers.getByteOrderMarksForCharset(this.charset));
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            output.write(bytes);
        }
        catch (IOException ex) {
            throw new TapeIOException("I/O error while writing from tape to output [" + output + "]: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void writeFrom(DataInput input) throws TapeIOException {
        try {
            this.charsetDecoder.reset();
            ByteBuffer writeBuffer = ByteBuffer.allocate(4);
            CharBuffer charBuffer = (CharBuffer)CharBuffer.allocate(4).flip();
            while (!UnicodeBuffers.getFirstCodePoint(charBuffer).isPresent()) {
                writeBuffer.put(input.readByte());
                ByteBuffer readBuffer = ByteBuffer.wrap(writeBuffer.array(), 0, writeBuffer.position());
                charBuffer.clear();
                CoderResult codeResult = this.charsetDecoder.decode(readBuffer, charBuffer, false);
                charBuffer.flip();
                if (!codeResult.isOverflow() && !codeResult.isError()) continue;
                codeResult.throwException();
            }
            this.write(UnicodeBuffers.getFirstCodePoint(charBuffer).getAsInt());
        }
        catch (EOFException ex) {
            this.write(this.eofBehaviour.getEofValue(this, input));
        }
        catch (IOException ex) {
            throw new TapeIOException("I/O error while reading from input [" + input + "] to tape: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isZero() {
        return ((Integer)this.read()).equals(0);
    }
}

