/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.program;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import de.fxnn.brainfuck.program.Program;
import de.fxnn.brainfuck.program.StringProgram;
import de.fxnn.brainfuck.program.TreeProgram;
import de.fxnn.util.IteratorToIterable;
import java.util.Iterator;
import java.util.List;

public class TreePrograms {
    private TreePrograms() {
    }

    public static Iterator<Program> searchProgramsDepthFirst(Program program) {
        UnmodifiableIterator singletonIterator = Iterators.singletonIterator((Object)program);
        if (program instanceof TreeProgram) {
            return Iterators.concat((Iterator)singletonIterator, ((TreeProgram)program).iterator());
        }
        return singletonIterator;
    }

    public static String toString(Program program) {
        StringBuilder resultBuilder = new StringBuilder();
        UnmodifiableIterator stringPrograms = Iterators.filter(TreePrograms.searchProgramsDepthFirst(program), StringProgram.class);
        for (StringProgram p : IteratorToIterable.iterateOnce(stringPrograms)) {
            resultBuilder.append(p.getProgram());
        }
        return resultBuilder.toString();
    }

    public static int getTotalStringProgramLength(Program program) {
        if (program instanceof StringProgram) {
            return ((StringProgram)program).getProgram().length();
        }
        if (program instanceof TreeProgram) {
            int result = 0;
            List<Program> childPrograms = ((TreeProgram)program).getChildPrograms();
            for (Program childProgram : childPrograms) {
                result += TreePrograms.getTotalStringProgramLength(childProgram);
            }
            return result;
        }
        throw new IllegalArgumentException("Program not supported: " + program);
    }
}

