/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.program;

import de.fxnn.brainfuck.program.AbstractInstructionPointer;
import de.fxnn.brainfuck.program.InstructionPointer;
import de.fxnn.brainfuck.program.InvalidInstructionPointer;
import de.fxnn.brainfuck.program.Program;
import java.util.List;

public class TreeInstructionPointer
extends AbstractInstructionPointer {
    private final List<Program> childPrograms;
    private final int childProgramIndex;
    private final InstructionPointer childInstructionPointer;

    protected TreeInstructionPointer(List<Program> childPrograms, int childProgramIndex, InstructionPointer childInstructionPointer) {
        this.childPrograms = childPrograms;
        this.childProgramIndex = childProgramIndex;
        this.childInstructionPointer = childInstructionPointer;
    }

    @Override
    public char getInstruction() {
        return this.childInstructionPointer.getInstruction();
    }

    @Override
    public InstructionPointer forward() {
        InstructionPointer nextChildInstructionPointer = this.childInstructionPointer.forward();
        if (InvalidInstructionPointer.invalidInstructionPointer().equals(nextChildInstructionPointer)) {
            return TreeInstructionPointer.createInstructionPointerAt(this.childPrograms, this.childProgramIndex + 1);
        }
        return new TreeInstructionPointer(this.childPrograms, this.childProgramIndex, nextChildInstructionPointer);
    }

    public static InstructionPointer createInstructionPointer(List<Program> childPrograms) {
        return TreeInstructionPointer.createInstructionPointerAt(childPrograms, 0);
    }

    protected static InstructionPointer createInstructionPointerAt(List<Program> childPrograms, int childProgramIndex) {
        for (int correctedChildProgramIndex = childProgramIndex; correctedChildProgramIndex < childPrograms.size(); ++correctedChildProgramIndex) {
            InstructionPointer childInstructionPointer = TreeInstructionPointer.firstInstructionAt(childPrograms, correctedChildProgramIndex);
            if (InvalidInstructionPointer.invalidInstructionPointer().equals(childInstructionPointer)) continue;
            return new TreeInstructionPointer(childPrograms, correctedChildProgramIndex, childInstructionPointer);
        }
        return InvalidInstructionPointer.invalidInstructionPointer();
    }

    protected static InstructionPointer firstInstructionAt(List<Program> childPrograms, int childProgramIndex) {
        try {
            return childPrograms.get(childProgramIndex).getStartOfProgram();
        }
        catch (IndexOutOfBoundsException ex) {
            return InvalidInstructionPointer.invalidInstructionPointer();
        }
    }
}

