/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.program;

import com.google.common.base.Objects;
import de.fxnn.brainfuck.program.InstructionPointer;
import de.fxnn.brainfuck.program.InvalidInstructionPointer;
import de.fxnn.brainfuck.program.Program;
import de.fxnn.brainfuck.program.StringInstructionPointer;

public class StringProgram
implements Program {
    private final String program;

    public StringProgram(String program) {
        this.program = program;
    }

    @Override
    public InstructionPointer getStartOfProgram() {
        if (this.program.isEmpty()) {
            return InvalidInstructionPointer.invalidInstructionPointer();
        }
        return new StringInstructionPointer(this.program, 0);
    }

    public String getProgram() {
        return this.program;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringProgram that = (StringProgram)o;
        return Objects.equal((Object)this.program, (Object)that.program);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.program});
    }

    public String toString() {
        return "StringProgram(program=" + this.getProgram() + ")";
    }
}

