/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.interpreter;

import de.fxnn.brainfuck.interpreter.InterpreterException;
import de.fxnn.brainfuck.interpreter.LoopHandlingBrainfuckInstructionSet;
import de.fxnn.brainfuck.interpreter.LoopMode;
import de.fxnn.brainfuck.program.InstructionPointer;
import de.fxnn.brainfuck.tape.OutOfTapeBoundsException;
import de.fxnn.brainfuck.tape.Tape;
import de.fxnn.brainfuck.tape.TapeIOException;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Deque;

public class FullBrainfuckInstructionSet
extends LoopHandlingBrainfuckInstructionSet {
    protected final DataInput input;
    protected final DataOutput output;

    public FullBrainfuckInstructionSet(Deque<InstructionPointer> instructionPointerStack, Deque<LoopMode> loopModeStack, Tape<?> tape, DataInput input, DataOutput output) {
        super(instructionPointerStack, loopModeStack, tape);
        this.input = input;
        this.output = output;
    }

    @Override
    public InstructionPointer moveForward(InstructionPointer instructionPointer) throws InterpreterException {
        try {
            this.tape.moveForward();
            return super.moveForward(instructionPointer);
        }
        catch (OutOfTapeBoundsException e) {
            throw new InterpreterException("End of tape reached while moving forward", e);
        }
    }

    @Override
    public InstructionPointer moveBackward(InstructionPointer instructionPointer) throws InterpreterException {
        try {
            this.tape.moveBackward();
            return super.moveBackward(instructionPointer);
        }
        catch (OutOfTapeBoundsException e) {
            throw new InterpreterException("End of tape reached while moving backward", e);
        }
    }

    @Override
    public InstructionPointer increment(InstructionPointer instructionPointer) throws InterpreterException {
        this.tape.increment();
        return super.increment(instructionPointer);
    }

    @Override
    public InstructionPointer decrement(InstructionPointer instructionPointer) throws InterpreterException {
        this.tape.decrement();
        return super.decrement(instructionPointer);
    }

    @Override
    public InstructionPointer output(InstructionPointer instructionPointer) throws InterpreterException {
        try {
            this.tape.readTo(this.output);
            return super.output(instructionPointer);
        }
        catch (TapeIOException e) {
            throw new InterpreterException("Sending tape contents to output failed", e);
        }
    }

    @Override
    public InstructionPointer input(InstructionPointer instructionPointer) throws InterpreterException {
        try {
            this.tape.writeFrom(this.input);
            return super.input(instructionPointer);
        }
        catch (TapeIOException e) {
            throw new InterpreterException("Reading input to tape failed", e);
        }
    }
}

