/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.cli;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import de.fxnn.brainfuck.ProgramBuilder;
import de.fxnn.brainfuck.cli.BrainfuckApplicationConfiguration;
import de.fxnn.brainfuck.cli.ProgramStartupException;
import de.fxnn.brainfuck.program.EmptyProgram;
import de.fxnn.brainfuck.program.StringProgram;
import de.fxnn.brainfuck.tape.InfiniteCharacterTape;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class BrainfuckProgramStartup
implements Closeable {
    final Charset programCharset;
    final Charset tapeCharset;
    final InputStream stdinStream;
    boolean stdinAtItsEnd = false;
    final OutputStream stdoutStream;
    final List<Closeable> closeables;
    final BrainfuckApplicationConfiguration configuration;

    public BrainfuckProgramStartup(InputStream stdinStream, OutputStream stdoutStream, BrainfuckApplicationConfiguration configuration) {
        this.programCharset = configuration.getProgramCharset();
        this.tapeCharset = configuration.getTapeCharset();
        this.stdinStream = stdinStream;
        this.stdoutStream = stdoutStream;
        this.configuration = configuration;
        this.closeables = new LinkedList<Closeable>();
    }

    @Override
    public void close() throws IOException {
        this.stdinStream.close();
        this.stdoutStream.close();
        for (Closeable closeable : this.closeables) {
            closeable.close();
        }
    }

    public void startProgramFromCommandlineArgument(String argument) throws ProgramStartupException {
        ProgramBuilder programBuilder = this.createProgramBuilder(this.tapeCharset).withInput(this.getDataInputFromStdin()).withOutput(this.getDataOutputFromStdout());
        if (this.configuration.isProgramGivenAsArgument()) {
            programBuilder.withProgram(new StringProgram(argument));
        } else if (argument.equals("-")) {
            programBuilder.withInput(BrainfuckProgramStartup.emptyProgramInput()).withProgram(new StringProgram(this.readProgramFromInputStream(this.programCharset)));
        } else {
            programBuilder.withProgram(new StringProgram(this.readProgramFromPath(argument, this.programCharset)));
        }
        if (this.configuration.getInputFile() != null) {
            programBuilder.withInput(this.getDataInputFromFile(this.configuration.getInputFile()));
        }
        if (this.configuration.getOutputFile() != null) {
            programBuilder.withOutput(this.getDataOutputFromFile(this.configuration.getOutputFile()));
        }
        this.execute(programBuilder);
    }

    protected DataOutput getDataOutputFromFile(@Nonnull File outputFile) throws ProgramStartupException {
        try {
            OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            DataOutputStream result = new DataOutputStream(outputStream);
            this.closeables.add(result);
            return result;
        }
        catch (IOException e) {
            throw new ProgramStartupException("Could not open file \"" + this.configuration.getInputFile() + "\" for output.", e);
        }
    }

    protected DataInput getDataInputFromFile(@Nonnull File inputFile) throws ProgramStartupException {
        try {
            InputStream inputStream = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);
            DataInputStream result = new DataInputStream(inputStream);
            this.closeables.add(result);
            return result;
        }
        catch (IOException e) {
            throw new ProgramStartupException("Could not open file \"" + this.configuration.getInputFile() + "\" for input.", e);
        }
    }

    protected void execute(ProgramBuilder programBuilder) {
        programBuilder.buildProgramExecutor().run();
    }

    protected ProgramBuilder createProgramBuilder(Charset tapeCharset) {
        return new ProgramBuilder().withProgram(new EmptyProgram()).withTape(new InfiniteCharacterTape(tapeCharset, this.configuration.getEofBehaviour())).withInput(BrainfuckProgramStartup.emptyProgramInput()).withOutput(BrainfuckProgramStartup.noProgramOutput());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readProgramFromPath(String programPath, Charset programCharset) throws ProgramStartupException {
        try (BufferedReader fileReader = Files.newBufferedReader(Paths.get(programPath, new String[0]), programCharset);){
            String string = CharStreams.toString((Readable)fileReader);
            return string;
        }
        catch (IOException ex) {
            throw new ProgramStartupException("Could not read program from path \"" + programPath + "\": " + ex.getMessage(), ex);
        }
    }

    protected String readProgramFromInputStream(Charset programCharset) throws ProgramStartupException {
        try {
            String result = CharStreams.toString((Readable)new BufferedReader(new InputStreamReader(this.stdinStream, programCharset)));
            this.stdinAtItsEnd = true;
            return result;
        }
        catch (IOException ex) {
            throw new ProgramStartupException("Could not read program from input stream: " + ex.getMessage(), ex);
        }
    }

    private DataOutput getDataOutputFromStdout() {
        return new DataOutputStream(this.stdoutStream);
    }

    protected DataInput getDataInputFromStdin() throws ProgramStartupException {
        if (this.stdinAtItsEnd) {
            throw new ProgramStartupException("The input was already read to its end!");
        }
        return new DataInputStream(this.stdinStream);
    }

    protected static DataOutput noProgramOutput() {
        return new DataOutputStream(ByteStreams.nullOutputStream());
    }

    protected static DataInput emptyProgramInput() {
        return ByteStreams.newDataInput((byte[])new byte[0]);
    }
}

