/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.cli;

import com.google.common.base.Joiner;
import de.fxnn.brainfuck.ProgramExecutionException;
import de.fxnn.brainfuck.cli.BrainfuckApplicationConfiguration;
import de.fxnn.brainfuck.cli.BrainfuckOptionsFactory;
import de.fxnn.brainfuck.cli.BrainfuckProgramStartup;
import de.fxnn.brainfuck.cli.ProgramStartupException;
import de.fxnn.brainfuck.tape.TapeEofBehaviour;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class BrainfuckApplication
implements Runnable {
    static final String APPLICATION_URL = "http://github.com/fxnn/brainfuck";
    private final String[] args;
    private final InputStream inStream;
    private final OutputStream outStream;
    private final PrintWriter errWriter;
    private final Options options;

    public static void main(String[] args) {
        new BrainfuckApplication(args, System.in, System.out, System.err).run();
    }

    public BrainfuckApplication(String[] args, InputStream inStream, OutputStream outStream, PrintStream errStream) {
        this.args = args;
        this.inStream = inStream;
        this.outStream = outStream;
        this.errWriter = new PrintWriter(errStream);
        this.options = new BrainfuckOptionsFactory().createOptions();
    }

    @Override
    public void run() {
        try {
            CommandLine commandLine = new PosixParser().parse(this.options, this.args);
            BrainfuckApplicationConfiguration configuration = new BrainfuckApplicationConfiguration();
            if (commandLine.getArgList().isEmpty()) {
                this.displayHelp();
                return;
            }
            if (commandLine.hasOption("help")) {
                this.displayHelp();
                return;
            }
            configuration.setTapeCharset(this.readCharset(commandLine, "tapeenc"));
            configuration.setProgramCharset(this.readCharset(commandLine, "progenc"));
            configuration.setEofBehaviour(BrainfuckOptionsFactory.eofBehaviourFromArgument(commandLine.getOptionValue("eof"), TapeEofBehaviour.READS_ZERO));
            configuration.setProgramGivenAsArgument(commandLine.hasOption("progarg"));
            configuration.setInputFile((File)commandLine.getParsedOptionValue("infile"));
            configuration.setOutputFile((File)commandLine.getParsedOptionValue("outfile"));
            this.runBrainfuckPrograms(commandLine.getArgList(), configuration);
        }
        catch (ParseException e) {
            this.errWriter.println("ERROR: Could not parse commandline arguments.");
            this.errWriter.println(e.getMessage());
            this.displayHelp();
        }
        catch (ProgramExecutionException | ProgramStartupException e) {
            this.errWriter.println("ERROR: " + e.getMessage());
        }
        finally {
            this.errWriter.close();
        }
    }

    protected Charset readCharset(CommandLine commandLine, String opt) throws ProgramStartupException {
        String defaultValue = Charset.defaultCharset().name();
        String optionValue = commandLine.getOptionValue(opt, defaultValue);
        try {
            return Charset.forName(optionValue);
        }
        catch (IllegalCharsetNameException ex) {
            throw new ProgramStartupException("That is no legal charset name: " + ex.getCharsetName());
        }
        catch (UnsupportedCharsetException ex) {
            throw new ProgramStartupException("This charset is not supported on this JVM: " + ex.getCharsetName());
        }
    }

    protected void runBrainfuckPrograms(List<String> arguments, BrainfuckApplicationConfiguration configuration) throws ProgramStartupException {
        try (BrainfuckProgramStartup programStartup = this.createBrainfuckProgramStartup(configuration);){
            if (configuration.isProgramGivenAsArgument()) {
                programStartup.startProgramFromCommandlineArgument(Joiner.on((String)" ").join(arguments));
            } else {
                for (String argument : arguments) {
                    programStartup.startProgramFromCommandlineArgument(argument);
                }
            }
        }
        catch (IOException ex) {
            throw new ProgramStartupException("Error while handling i/o: " + ex.getMessage(), ex);
        }
    }

    protected BrainfuckProgramStartup createBrainfuckProgramStartup(BrainfuckApplicationConfiguration configuration) {
        return new BrainfuckProgramStartup(this.inStream, this.outStream, configuration);
    }

    protected void displayHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String header = APPLICATION_URL;
        String footer = "By default, program names are paths to files containing programs. Programs are executed sequentially on different tapes. To read a single program from stdin, use \"-\" as program name.";
        String usage = this.getExecutableName() + " [options] program1 [program2 [...]]";
        helpFormatter.printHelp(this.errWriter, 74, usage, header, this.options, 1, 3, footer, false);
    }

    private String getExecutableName() {
        return "java -jar brainfuck.jar";
    }
}

