/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright.yenta;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.ModuleInstall;
import org.openide.modules.Modules;

public abstract class Yenta
extends ModuleInstall {
    protected Yenta() {
    }

    protected Set<String> friends() {
        return Collections.emptySet();
    }

    protected Set<String> siblings() {
        return Collections.emptySet();
    }

    public void validate() throws IllegalStateException {
        Set<String> friends = this.friends();
        Set<String> siblings = this.siblings();
        if (friends.isEmpty() && siblings.isEmpty()) {
            throw new IllegalStateException("Must specify some friends and/or siblings");
        }
        ModuleInfo me = Modules.getDefault().ownerOf(((Object)((Object)this)).getClass());
        if (me == null) {
            throw new IllegalStateException("No apparent module owning " + ((Object)((Object)this)).getClass());
        }
        try {
            Object manager = me.getClass().getMethod("getManager", new Class[0]).invoke((Object)me, new Object[0]);
            for (String m : friends) {
                if (siblings.contains(m)) {
                    throw new IllegalStateException("Cannot specify the same module " + m + " in both friends and siblings");
                }
                Object data = this.data(this.findDependency(manager, m));
                Field friendNamesF = Class.forName("org.netbeans.ModuleData", true, data.getClass().getClassLoader()).getDeclaredField("friendNames");
                friendNamesF.setAccessible(true);
                Set names = (Set)friendNamesF.get(data);
                HashSet<String> newNames = new HashSet<String>(names);
                newNames.add(me.getCodeNameBase());
                friendNamesF.set(data, newNames);
            }
            for (String m : siblings) {
                ModuleInfo dep = this.findDependency(manager, m);
                String implVersion = dep.getImplementationVersion();
                if (implVersion == null) {
                    throw new IllegalStateException("No implementation version found in " + m);
                }
                Object data = this.data(me);
                Field dependenciesF = Class.forName("org.netbeans.ModuleData", true, data.getClass().getClassLoader()).getDeclaredField("dependencies");
                dependenciesF.setAccessible(true);
                Dependency[] dependencies = (Dependency[])dependenciesF.get(data);
                boolean found = false;
                for (int i = 0; i < dependencies.length; ++i) {
                    if (!dependencies[i].getName().replaceFirst("/.+$", "").equals(m)) continue;
                    Set nue = Dependency.create((int)1, (String)(dependencies[i].getName() + " = " + implVersion));
                    if (nue.size() != 1) {
                        throw new IllegalStateException("Could not recreate dependency from " + dependencies[i] + " based on " + implVersion);
                    }
                    dependencies[i] = (Dependency)nue.iterator().next();
                    found = true;
                }
                if (!found) {
                    throw new IllegalStateException("Did not find dependency on " + m);
                }
                Object[] publicPackages = (Object[])dep.getClass().getMethod("getPublicPackages", new Class[0]).invoke((Object)dep, new Object[0]);
                if (publicPackages == null || publicPackages.length != 0) continue;
                me.getClassLoader().getClass().getMethod("append", ClassLoader[].class).invoke((Object)me.getClassLoader(), new Object[]{new ClassLoader[]{dep.getClassLoader()}});
            }
        }
        catch (IllegalStateException x) {
            throw x;
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
    }

    private ModuleInfo findDependency(Object manager, String m) throws Exception {
        Object dep = manager.getClass().getMethod("get", String.class).invoke(manager, m);
        if (dep == null) {
            throw new IllegalStateException("No such dependency " + m);
        }
        return (ModuleInfo)dep;
    }

    private Object data(ModuleInfo module) throws Exception {
        Method dataM = Class.forName("org.netbeans.Module", true, module.getClass().getClassLoader()).getDeclaredMethod("data", new Class[0]);
        dataM.setAccessible(true);
        return dataM.invoke((Object)module, new Object[0]);
    }
}

