/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright.actions.topcomponent;

import de.funfried.netbeans.plugins.editor.closeleftright.AbstractBaseAction;
import java.awt.event.ActionEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class AbstractTopComponentBaseAction
extends AbstractBaseAction {
    private static final long serialVersionUID = 4175615224177055417L;
    protected final Class<? extends TopComponent>[] topComponentTypes;

    protected AbstractTopComponentBaseAction(String name, Class<? extends TopComponent> ... topComponentTypes) {
        super(name, (TopComponent)null);
        this.topComponentTypes = topComponentTypes;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.topComponent != null) {
            Mode mode = WindowManager.getDefault().findMode(this.topComponent);
            if (mode == null) {
                return;
            }
            for (TopComponent tc : mode.getTopComponents()) {
                if (!tc.isOpened() || !this.isAssignableFromGivenTypes(tc.getClass())) continue;
                tc.close();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.topComponent != null) {
            Mode mode = WindowManager.getDefault().findMode(this.topComponent);
            if (mode == null) {
                return false;
            }
            for (TopComponent tc : mode.getTopComponents()) {
                if (!tc.isOpened() || !this.isAssignableFromGivenTypes(tc.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAssignableFromGivenTypes(Class<? extends TopComponent> topComponentClass) {
        if (topComponentClass != null && ArrayUtils.isNotEmpty((Object[])this.topComponentTypes)) {
            for (Class<? extends TopComponent> topComponentType : this.topComponentTypes) {
                if (!topComponentClass.isAssignableFrom(topComponentType)) continue;
                return true;
            }
        }
        return false;
    }
}

