/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright.actions;

import de.funfried.netbeans.plugins.editor.closeleftright.AbstractBaseAction;
import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class AbstractInitialCloseBaseAction
extends AbstractBaseAction {
    private static final long serialVersionUID = -8499198129424546354L;
    private static final Logger log = Logger.getLogger(AbstractInitialCloseBaseAction.class.getName());
    protected final boolean initialClose;

    protected AbstractInitialCloseBaseAction(String name, TopComponent topComponent, boolean initialClose) {
        super(name, topComponent);
        this.initialClose = initialClose;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Mode mode = WindowManager.getDefault().findMode(this.topComponent);
        if (mode == null) {
            return;
        }
        boolean close = this.initialClose;
        for (TopComponent tc : mode.getTopComponents()) {
            if (Objects.equals(tc, this.topComponent)) {
                close = !close;
                continue;
            }
            if (!close || !tc.isOpened()) continue;
            tc.close();
        }
    }

    @Override
    public boolean isEnabled() {
        Mode mode = WindowManager.getDefault().findMode(this.topComponent);
        if (mode == null) {
            return false;
        }
        boolean close = this.initialClose;
        try {
            for (TopComponent tc : mode.getTopComponents()) {
                if (Objects.equals(tc, this.topComponent)) {
                    close = !close;
                    continue;
                }
                if (!close || !tc.isOpened()) continue;
                return true;
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Name", ex);
        }
        return false;
    }
}

