/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright.vcs;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public interface GitUtils {
    public static Boolean isModified(FileObject fileObject) {
        GitStatus.Status status = GitUtils.getStatus(fileObject);
        if (status == null) {
            return null;
        }
        return !GitStatus.Status.STATUS_NORMAL.equals((Object)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitStatus.Status getStatus(FileObject fileObject) {
        if (fileObject != null) {
            ProgressMonitor.DefaultProgressMonitor progressMonitor = new ProgressMonitor.DefaultProgressMonitor();
            GitRepository gitRepo = GitUtils.getRepo(fileObject);
            if (gitRepo != null) {
                GitClient client = null;
                try {
                    GitStatus gitStatus;
                    Map status;
                    client = gitRepo.createClient();
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (file != null && (status = client.getStatus(new File[]{file}, (ProgressMonitor)progressMonitor)) != null && (gitStatus = (GitStatus)status.get(file)) != null) {
                        GitStatus.Status status2 = gitStatus.getStatusIndexWC();
                        return status2;
                    }
                }
                catch (GitException ex) {
                    Logger.getLogger(GitUtils.class.getName()).log(Level.WARNING, "Fetching git status ran into", ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
            }
        }
        return null;
    }

    public static GitRepository getRepo(FileObject fileObject) {
        File file;
        FileObject gitRepoDirectory = GitUtils.getRepoDirectory(fileObject);
        if (gitRepoDirectory != null && (file = FileUtil.toFile((FileObject)gitRepoDirectory)) != null) {
            return GitRepository.getInstance((File)file);
        }
        return null;
    }

    public static FileObject getRepoDirectory(FileObject fileObject) {
        for (FileObject fileObj = fileObject; fileObj != null; fileObj = fileObj.getParent()) {
            if (!fileObj.isFolder() || fileObj.getFileObject(".git", "") == null) continue;
            return fileObj;
        }
        return null;
    }
}

