/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright.options;

import de.funfried.netbeans.plugins.editor.closeleftright.AdditionalCloseActionFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class AdditionalCloseActionsPanel
extends JPanel {
    private static final long serialVersionUID = 4588982272030513399L;
    private final Map<AdditionalCloseActionFactory, JCheckBox> actionChkBoxes = new HashMap<AdditionalCloseActionFactory, JCheckBox>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JPanel actionChkBoxesPanel;
    private JLabel descriptionLbl;
    private JCheckBox selectAllChkBox;

    AdditionalCloseActionsPanel() {
        this.initComponents();
        this.generateComponents();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    protected void fireChangedListener() {
        this.changeSupport.fireChange();
    }

    private void updateSelectAllChkBox() {
        boolean allSelected = true;
        for (AdditionalCloseActionFactory additionalCloseActionFactory : this.actionChkBoxes.keySet()) {
            JCheckBox actionChkBox = this.actionChkBoxes.get(additionalCloseActionFactory);
            if (actionChkBox.isSelected()) continue;
            allSelected = false;
            break;
        }
        this.selectAllChkBox.setSelected(allSelected);
    }

    private void generateComponents() {
        Collection additionalCloseActionFactories = Lookup.getDefault().lookupAll(AdditionalCloseActionFactory.class);
        for (AdditionalCloseActionFactory additionalCloseActionFactory : additionalCloseActionFactories) {
            JCheckBox actionChkBox = new JCheckBox(additionalCloseActionFactory.getName() + (!additionalCloseActionFactory.isGlobalAction() ? " (Editor context menu only)" : ""));
            actionChkBox.addActionListener(e -> {
                this.fireChangedListener();
                this.updateSelectAllChkBox();
            });
            this.actionChkBoxesPanel.add(actionChkBox);
            this.actionChkBoxes.put(additionalCloseActionFactory, actionChkBox);
        }
    }

    private void initComponents() {
        this.selectAllChkBox = new JCheckBox();
        this.descriptionLbl = new JLabel();
        this.actionChkBoxesPanel = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.selectAllChkBox, (String)NbBundle.getMessage(AdditionalCloseActionsPanel.class, (String)"AdditionalCloseActionsPanel.selectAllChkBox.text"));
        this.selectAllChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalCloseActionsPanel.this.selectAllChkBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.descriptionLbl, (String)NbBundle.getMessage(AdditionalCloseActionsPanel.class, (String)"AdditionalCloseActionsPanel.descriptionLbl.text"));
        this.actionChkBoxesPanel.setLayout(new BoxLayout(this.actionChkBoxesPanel, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionChkBoxesPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectAllChkBox).addComponent(this.descriptionLbl)).addGap(0, 42, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectAllChkBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.actionChkBoxesPanel, -1, 165, Short.MAX_VALUE).addContainerGap()));
    }

    private void selectAllChkBoxActionPerformed(ActionEvent evt) {
        for (AdditionalCloseActionFactory additionalCloseActionFactory : this.actionChkBoxes.keySet()) {
            JCheckBox actionChkBox = this.actionChkBoxes.get(additionalCloseActionFactory);
            actionChkBox.setSelected(this.selectAllChkBox.isSelected());
            this.fireChangedListener();
        }
    }

    void load() {
        for (AdditionalCloseActionFactory additionalCloseActionFactory : this.actionChkBoxes.keySet()) {
            JCheckBox actionChkBox = this.actionChkBoxes.get(additionalCloseActionFactory);
            actionChkBox.setSelected(additionalCloseActionFactory.isActive());
        }
        this.updateSelectAllChkBox();
    }

    void store() {
        for (AdditionalCloseActionFactory additionalCloseActionFactory : this.actionChkBoxes.keySet()) {
            JCheckBox actionChkBox = this.actionChkBoxes.get(additionalCloseActionFactory);
            additionalCloseActionFactory.setActive(actionChkBox.isSelected());
        }
    }

    boolean valid() {
        return true;
    }
}

