/*
 * Decompiled with CFR 0.152.
 */
package de.funfried.netbeans.plugins.editor.closeleftright.actions.vcs;

import de.funfried.netbeans.plugins.editor.closeleftright.AbstractBaseAction;
import de.funfried.netbeans.plugins.editor.closeleftright.vcs.GitUtils;
import de.funfried.netbeans.plugins.editor.closeleftright.vcs.HgUtils;
import de.funfried.netbeans.plugins.editor.closeleftright.vcs.SvnUtils;
import java.awt.event.ActionEvent;
import org.openide.filesystems.FileObject;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CloseCommitedAction
extends AbstractBaseAction {
    private static final long serialVersionUID = -1294837770606016114L;

    CloseCommitedAction(String name, TopComponent topComponent) {
        super(name, topComponent);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Mode mode = WindowManager.getDefault().findMode(this.topComponent);
        if (mode == null) {
            return;
        }
        for (TopComponent tc : mode.getTopComponents()) {
            FileObject fileObject;
            if (!tc.isOpened() || (fileObject = (FileObject)tc.getLookup().lookup(FileObject.class)) == null) continue;
            Boolean gitModified = GitUtils.isModified(fileObject);
            Boolean svnModified = SvnUtils.isModified(fileObject);
            Boolean hgModified = HgUtils.isModified(fileObject);
            if (Boolean.TRUE.equals(gitModified) || Boolean.TRUE.equals(svnModified) || Boolean.TRUE.equals(hgModified)) continue;
            tc.close();
        }
    }

    @Override
    public boolean isEnabled() {
        Mode mode = WindowManager.getDefault().findMode(this.topComponent);
        if (mode == null) {
            return false;
        }
        for (TopComponent tc : mode.getTopComponents()) {
            FileObject fileObject = (FileObject)tc.getLookup().lookup(FileObject.class);
            if (fileObject == null) continue;
            Boolean gitModified = GitUtils.isModified(fileObject);
            Boolean svnModified = SvnUtils.isModified(fileObject);
            Boolean hgModified = HgUtils.isModified(fileObject);
            if (Boolean.TRUE.equals(gitModified) || Boolean.TRUE.equals(svnModified) || Boolean.TRUE.equals(hgModified)) continue;
            return true;
        }
        return false;
    }
}

